/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.parser.errorhandler;

import com.helger.commons.annotation.Nonempty;
import com.helger.json.parser.JsonParseException;
import com.helger.json.parser.errorhandler.IJsonParseExceptionCallback;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class LoggingJsonParseExceptionCallback
implements IJsonParseExceptionCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingJsonParseExceptionCallback.class);

    @Nonnull
    @Nonempty
    public static String createLoggingStringParseError(@Nonnull JsonParseException jsonParseException) {
        return jsonParseException.getMessage();
    }

    @Override
    public void onException(@Nonnull JsonParseException jsonParseException) {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error(LoggingJsonParseExceptionCallback.createLoggingStringParseError(jsonParseException));
        }
    }
}

