/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.parser;

import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.json.parser.IJsonParsePosition;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class JsonParsePosition
implements ICloneable<JsonParsePosition>,
IJsonParsePosition {
    private int m_nLine;
    private int m_nColumn;
    private boolean m_bPrevCharIsCR = false;
    private boolean m_bPrevCharIsLF = false;

    public JsonParsePosition() {
        this.m_nLine = 1;
        this.m_nColumn = 1;
    }

    public JsonParsePosition(@Nonnull JsonParsePosition jsonParsePosition) {
        this.m_nLine = jsonParsePosition.m_nLine;
        this.m_nColumn = jsonParsePosition.m_nColumn;
    }

    protected void updatePosition(int n, int n2) {
        ++this.m_nColumn;
        if (this.m_bPrevCharIsLF) {
            this.m_bPrevCharIsLF = false;
            this.m_nColumn = 1;
            ++this.m_nLine;
        } else if (this.m_bPrevCharIsCR) {
            this.m_bPrevCharIsCR = false;
            if (n == 10) {
                this.m_bPrevCharIsLF = true;
            } else {
                this.m_nColumn = 1;
                ++this.m_nLine;
            }
        }
        switch (n) {
            case 13: {
                this.m_bPrevCharIsCR = true;
                break;
            }
            case 10: {
                this.m_bPrevCharIsLF = true;
                break;
            }
            case 9: {
                --this.m_nColumn;
                this.m_nColumn += n2 - this.m_nColumn % n2;
                break;
            }
        }
    }

    @Override
    @Nonnegative
    public int getLineNumber() {
        return this.m_nLine;
    }

    @Override
    @Nonnegative
    public int getColumnNumber() {
        return this.m_nColumn;
    }

    @Override
    @Nonnull
    public String getAsString() {
        return "[" + this.m_nLine + ":" + this.m_nColumn + "]";
    }

    @Override
    @Nonnull
    public JsonParsePosition getClone() {
        return new JsonParsePosition(this);
    }

    public String toString() {
        return new ToStringGenerator(this).append("line", this.m_nLine).append("column", this.m_nColumn).getToString();
    }
}

