/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.serialize.JsonReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class JsonArray
implements IJsonArray {
    private ICommonsList<IJson> m_aValues;

    public JsonArray() {
        this(16);
    }

    public JsonArray(@Nonnegative int n) {
        this.m_aValues = new CommonsArrayList<int>(n);
    }

    public JsonArray(@Nonnull Iterable<? extends IJson> iterable) {
        ValueEnforcer.notNull(iterable, "Jsons");
        this.m_aValues = new CommonsArrayList<Iterable<? extends IJson>>(iterable);
    }

    public JsonArray(IJson ... iJsonArray) {
        ValueEnforcer.notNull(iJsonArray, "Jsons");
        this.m_aValues = new CommonsArrayList<IJson>(iJsonArray);
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.m_aValues.size());
        String string = this.getAsJsonString();
        StreamHelper.writeSafeUTF(objectOutputStream, string);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        this.m_aValues = new CommonsArrayList<int>(n);
        String string = StreamHelper.readSafeUTF(objectInputStream);
        JsonArray jsonArray = (JsonArray)JsonReader.readFromString(string);
        if (jsonArray == null) {
            throw new IOException("Failed to parse JSON array:\n" + string);
        }
        this.m_aValues.addAll(jsonArray.m_aValues);
    }

    @Override
    public final boolean isArray() {
        return true;
    }

    @Override
    public final boolean isObject() {
        return false;
    }

    @Override
    public final boolean isValue() {
        return false;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aValues.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aValues.isEmpty();
    }

    @Override
    @Nonnull
    public Iterator<IJson> iterator() {
        return this.m_aValues.iterator();
    }

    @Override
    @Nonnull
    public JsonArray add(@Nonnull IJson iJson) {
        ValueEnforcer.notNull(iJson, "Value");
        this.m_aValues.add(iJson);
        return this;
    }

    @Override
    @Nonnull
    public JsonArray addAt(@Nonnegative int n, @Nonnull IJson iJson) {
        ValueEnforcer.notNull(iJson, "Value");
        this.m_aValues.add(n, iJson);
        return this;
    }

    @Override
    @Nonnull
    public IJson removeAndReturnAtIndex(@Nonnegative int n) {
        return this.m_aValues.removeAndReturnElementAtIndex(n);
    }

    @Override
    @Nonnull
    public EChange removeAtIndex(@Nonnegative int n) {
        return this.m_aValues.removeAtIndex(n);
    }

    @Override
    @Nullable
    public IJson get(@Nonnegative int n) {
        return (IJson)this.m_aValues.getAtIndex(n);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public JsonArray getSubArray(@Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isGE0(n, "StartIndex");
        ValueEnforcer.isBetweenInclusive(n2, "EndIndex", n, this.m_aValues.size());
        int n3 = n2 - n;
        JsonArray jsonArray = new JsonArray(n3);
        jsonArray.addAll(this.m_aValues.subList(n, n2));
        return jsonArray;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJson> getAll() {
        return (ICommonsList)this.m_aValues.getClone();
    }

    @Override
    public void forEach(@Nonnull Consumer<? super IJson> consumer) {
        this.m_aValues.forEach(consumer);
    }

    @Override
    public void forEachByIndex(@Nonnull ObjIntConsumer<? super IJson> objIntConsumer) {
        this.m_aValues.forEachByIndex(objIntConsumer);
    }

    @Override
    public boolean contains(@Nullable IJson iJson) {
        return iJson != null && this.m_aValues.contains(iJson);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJson> getClonedValues() {
        return this.m_aValues.getAllMapped(ICloneable::getClone);
    }

    @Override
    @Nonnull
    public JsonArray getClone() {
        return new JsonArray(this.getClonedValues());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JsonArray jsonArray = (JsonArray)object;
        return this.m_aValues.equals(jsonArray.m_aValues);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aValues)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("values", this.m_aValues).getToString();
    }
}

