/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.commons.traits.IGenericAdderTrait;
import com.helger.commons.traits.IGetterByIndexTrait;
import com.helger.commons.traits.IPrimitiveConverterTo;
import com.helger.json.IJson;
import com.helger.json.IJsonCollection;
import com.helger.json.IJsonObject;
import com.helger.json.IJsonValue;
import com.helger.json.JsonValue;
import com.helger.json.PrimitiveConvererToIJson;
import java.util.function.ObjIntConsumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IJsonArray
extends IJsonCollection,
ICommonsIterable<IJson>,
IGetterByIndexTrait,
IGenericAdderTrait<IJson, IJsonArray> {
    @Override
    @Nonnull
    default public IPrimitiveConverterTo<IJson> getPrimitiveConverterTo() {
        return PrimitiveConvererToIJson.INSTANCE;
    }

    @Nullable
    public IJson removeAndReturnAtIndex(@Nonnegative int var1);

    @Nonnull
    public EChange removeAtIndex(@Nonnegative int var1);

    @Nullable
    public IJson get(@Nonnegative int var1);

    @Nullable
    default public IJsonValue getValueAtIndex(@Nonnegative int n) {
        IJson iJson = this.get(n);
        return iJson != null && iJson.isValue() ? (IJsonValue)iJson : null;
    }

    @Nullable
    default public IJsonArray getArrayAtIndex(@Nonnegative int n) {
        IJson iJson = this.get(n);
        return iJson != null && iJson.isArray() ? (IJsonArray)iJson : null;
    }

    @Nullable
    default public IJsonObject getObjectAtIndex(@Nonnegative int n) {
        IJson iJson = this.get(n);
        return iJson != null && iJson.isObject() ? (IJsonObject)iJson : null;
    }

    @Override
    @Nullable
    default public Object getValue(@Nonnegative int n) {
        IJson iJson = this.get(n);
        return iJson != null && iJson.isValue() ? iJson.getAsValue().getValue() : null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public IJsonArray getSubArray(@Nonnegative int var1, @Nonnegative int var2);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJson> getAll();

    @Override
    public void forEachByIndex(@Nonnull ObjIntConsumer<? super IJson> var1);

    public boolean contains(@Nullable IJson var1);

    default public boolean contains(@Nullable Object object) {
        return this.contains(JsonValue.create(object));
    }

    default public boolean contains(boolean bl) {
        return this.contains(JsonValue.create(bl));
    }

    default public boolean contains(char c) {
        return this.contains(JsonValue.create(c));
    }

    default public boolean contains(double d) {
        return this.contains(JsonValue.create(d));
    }

    default public boolean contains(int n) {
        return this.contains(JsonValue.create(n));
    }

    default public boolean contains(long l) {
        return this.contains(JsonValue.create(l));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJson> getClonedValues();

    @Override
    @Nonnull
    public IJsonArray getClone();
}

