/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient.security;

import com.helger.commons.ValueEnforcer;
import java.net.Socket;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateKeyStrategyFromAliasCaseSensitive
implements PrivateKeyStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrivateKeyStrategyFromAliasCaseSensitive.class);
    private final String m_sExpectedAlias;

    public PrivateKeyStrategyFromAliasCaseSensitive(@Nonnull String string) {
        ValueEnforcer.notNull(string, "ExpectedAlias");
        this.m_sExpectedAlias = string;
    }

    @Nonnull
    public final String getExpectedAlias() {
        return this.m_sExpectedAlias;
    }

    @Override
    @Nullable
    public String chooseAlias(@Nonnull Map<String, PrivateKeyDetails> map, @Nullable Socket socket) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("chooseAlias(" + map + ", " + socket + ")");
        }
        for (String string : map.keySet()) {
            if (!string.equals(this.m_sExpectedAlias)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  Chose alias '" + string + "'");
            }
            return string;
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Found no certificate alias matching '" + this.m_sExpectedAlias + "' in the provided aliases " + map.keySet());
        }
        return null;
    }
}

