/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient.response;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ArrayHelper;
import com.helger.httpclient.HttpClientHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;

public class ExtendedHttpResponseException
extends HttpResponseException {
    private final transient StatusLine m_aStatusLine;
    private final transient HttpResponse m_aHttpResponse;
    private final byte[] m_aResponseBody;
    private final transient Charset m_aResponseCharset;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ExtendedHttpResponseException(@Nonnull StatusLine statusLine, @Nonnull HttpResponse httpResponse, @Nullable byte[] byArray, @Nonnull Charset charset) {
        super(statusLine.getStatusCode(), statusLine.getReasonPhrase() + " [" + statusLine.getStatusCode() + "]");
        ValueEnforcer.notNull(httpResponse, "HTTPResponse");
        ValueEnforcer.notNull(charset, "Charset");
        this.m_aStatusLine = statusLine;
        this.m_aHttpResponse = httpResponse;
        this.m_aResponseBody = byArray;
        this.m_aResponseCharset = charset;
    }

    @Nonnull
    public final StatusLine getStatusLine() {
        return this.m_aStatusLine;
    }

    @Nonnull
    public final HttpResponse getHttpResponse() {
        return this.m_aHttpResponse;
    }

    @Nullable
    @ReturnsMutableObject
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public final byte[] directGetResponseBody() {
        return this.m_aResponseBody;
    }

    @Nullable
    @ReturnsMutableCopy
    public final byte[] getResponseBody() {
        return ArrayHelper.getCopy(this.m_aResponseBody);
    }

    public final boolean hasResponseBody() {
        return ArrayHelper.isNotEmpty(this.m_aResponseBody);
    }

    @Nonnull
    public final Charset getResponseCharset() {
        return this.m_aResponseCharset;
    }

    @Nullable
    public final String getResponseBodyAsString() {
        return this.getResponseBodyAsString(this.m_aResponseCharset);
    }

    @Nullable
    public final String getResponseBodyAsString(@Nonnull Charset charset) {
        return this.m_aResponseBody == null ? null : new String(this.m_aResponseBody, charset);
    }

    @Override
    @Nonnull
    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_aStatusLine.getReasonPhrase()).append(" [").append(this.m_aStatusLine.getStatusCode()).append(']');
        Header[] headerArray = this.m_aHttpResponse.getAllHeaders();
        stringBuilder.append("\nAll ").append(headerArray.length).append(" headers returned");
        for (Header header : headerArray) {
            stringBuilder.append("\n  ").append(header.getName()).append('=').append(header.getValue());
        }
        if (this.m_aResponseBody != null) {
            stringBuilder.append("\nResponse Body (in ").append(this.getResponseCharset().name()).append("):\n").append(this.getResponseBodyAsString());
        } else {
            stringBuilder.append("\nNo Response Body present!");
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static ExtendedHttpResponseException create(@Nonnull StatusLine statusLine, @Nonnull HttpResponse httpResponse, @Nonnull HttpEntity httpEntity) throws IOException {
        ContentType contentType = ContentType.get(httpEntity);
        if (contentType == null) {
            contentType = ContentType.DEFAULT_TEXT;
        }
        Charset charset = HttpClientHelper.getCharset(contentType);
        byte[] byArray = EntityUtils.toByteArray(httpEntity);
        return new ExtendedHttpResponseException(statusLine, httpResponse, byArray, charset);
    }
}

