/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.lang.ClassHelper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.http.conn.DnsResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TextParseException;

@Immutable
public class NonCachingDnsResolver
implements DnsResolver {
    public static final NonCachingDnsResolver INSTANCE = new NonCachingDnsResolver();
    private static final Logger LOGGER = LoggerFactory.getLogger(NonCachingDnsResolver.class);

    @Nonnull
    protected Lookup createLookup(@Nonnull String string) throws TextParseException {
        Lookup lookup2 = new Lookup(string, 255);
        try {
            lookup2.setResolver(new SimpleResolver());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        lookup2.setCache(null);
        return lookup2;
    }

    @Override
    @Nonnull
    public InetAddress[] resolve(@Nonnull String string) throws UnknownHostException {
        Object[] objectArray;
        Record[] recordArray;
        block9: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("DNS resolving host '" + string + "'");
            }
            recordArray = null;
            try {
                objectArray = this.createLookup(string);
                recordArray = objectArray.run();
            }
            catch (TextParseException textParseException) {
                if (!LOGGER.isErrorEnabled()) break block9;
                LOGGER.error("Failed to parse host '" + string + "'", textParseException);
            }
        }
        if (recordArray == null || recordArray.length == 0) {
            objectArray = InetAddress.getAllByName(string);
        } else {
            CommonsArrayList<InetAddress> commonsArrayList = new CommonsArrayList<InetAddress>();
            for (Record record : recordArray) {
                Object object;
                if (record instanceof CNAMERecord) {
                    object = this.resolve(((CNAMERecord)record).getAlias().toString());
                    if (object == null) continue;
                    commonsArrayList.addAll(object);
                    continue;
                }
                if (record instanceof ARecord) {
                    object = ((ARecord)record).getAddress();
                    commonsArrayList.add(object);
                    continue;
                }
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.info("Unknown record type found for host '" + string + "': " + ClassHelper.getClassLocalName(record));
            }
            objectArray = commonsArrayList.toArray(new InetAddress[commonsArrayList.size()]);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Return for '" + string + "': " + Arrays.toString(objectArray));
        }
        return objectArray;
    }
}

