/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.ws.HostnameVerifierVerifyAll;
import com.helger.commons.ws.TrustManagerTrustAll;
import com.helger.http.tls.ETLSVersion;
import com.helger.http.tls.ITLSConfigurationMode;
import com.helger.http.tls.TLSConfigurationMode;
import com.helger.httpclient.HttpClientRetryHandler;
import com.helger.httpclient.IHttpClientSettings;
import java.security.GeneralSecurityException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HttpClientSettings
implements IHttpClientSettings,
ICloneable<HttpClientSettings> {
    public static final ITLSConfigurationMode DEFAULT_TLS_CONFIG_MODE = new TLSConfigurationMode(new ETLSVersion[]{ETLSVersion.TLS_12, ETLSVersion.TLS_11, ETLSVersion.TLS_10}, new String[0]);
    public static final boolean DEFAULT_USE_SYSTEM_PROPERTIES = false;
    public static final boolean DEFAULT_USE_DNS_CACHE = true;
    public static final int DEFAULT_RETRIES = 0;
    public static final HttpClientRetryHandler.ERetryMode DEFAULT_RETRY_MODE = HttpClientRetryHandler.ERetryMode.RETRY_IDEMPOTENT_ONLY;
    public static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT_MS = 5000;
    public static final int DEFAULT_CONNECTION_TIMEOUT_MS = 5000;
    public static final int DEFAULT_SOCKET_TIMEOUT_MS = 10000;
    public static final boolean DEFAULT_FOLLOW_REDIRECTS = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientSettings.class);
    private boolean m_bUseSystemProperties = false;
    private boolean m_bUseDNSClientCache = true;
    private SSLContext m_aSSLContext;
    private ITLSConfigurationMode m_aTLSConfigurationMode;
    private HostnameVerifier m_aHostnameVerifier;
    private HttpHost m_aProxyHost;
    private Credentials m_aProxyCredentials;
    private final ICommonsOrderedSet<String> m_aNonProxyHosts = new CommonsLinkedHashSet<String>();
    private int m_nRetryCount = 0;
    private HttpClientRetryHandler.ERetryMode m_eRetryMode = DEFAULT_RETRY_MODE;
    private int m_nConnectionRequestTimeoutMS = 5000;
    private int m_nConnectionTimeoutMS = 5000;
    private int m_nSocketTimeoutMS = 10000;
    private String m_sUserAgent;
    private boolean m_bFollowRedirects = true;

    public HttpClientSettings() {
    }

    public HttpClientSettings(@Nonnull IHttpClientSettings iHttpClientSettings) {
        this.setAllFrom(iHttpClientSettings);
    }

    @Nonnull
    public final HttpClientSettings setAllFrom(@Nonnull IHttpClientSettings iHttpClientSettings) {
        ValueEnforcer.notNull(iHttpClientSettings, "Source");
        this.setUseSystemProperties(iHttpClientSettings.isUseSystemProperties());
        this.setUseDNSClientCache(iHttpClientSettings.isUseDNSClientCache());
        this.setSSLContext(iHttpClientSettings.getSSLContext());
        this.setTLSConfigurationMode(iHttpClientSettings.getTLSConfigurationMode());
        this.setHostnameVerifier(iHttpClientSettings.getHostnameVerifier());
        this.setProxyHost(iHttpClientSettings.getProxyHost());
        this.setProxyCredentials(iHttpClientSettings.getProxyCredentials());
        this.nonProxyHosts().setAll(iHttpClientSettings.nonProxyHosts());
        this.setRetryCount(iHttpClientSettings.getRetryCount());
        this.setRetryMode(iHttpClientSettings.getRetryMode());
        this.setConnectionRequestTimeoutMS(iHttpClientSettings.getConnectionRequestTimeoutMS());
        this.setConnectionTimeoutMS(iHttpClientSettings.getConnectionTimeoutMS());
        this.setSocketTimeoutMS(iHttpClientSettings.getSocketTimeoutMS());
        this.setUserAgent(iHttpClientSettings.getUserAgent());
        this.setFollowRedirects(iHttpClientSettings.isFollowRedirects());
        return this;
    }

    @Override
    public final boolean isUseSystemProperties() {
        return this.m_bUseSystemProperties;
    }

    @Nonnull
    public final HttpClientSettings setUseSystemProperties(boolean bl) {
        this.m_bUseSystemProperties = bl;
        if (bl && this.m_aProxyHost != null) {
            LOGGER.warn("Since the proxy properties should be used, the explicit Proxy host is removed.");
            this.m_aProxyHost = null;
        }
        return this;
    }

    @Override
    public final boolean isUseDNSClientCache() {
        return this.m_bUseDNSClientCache;
    }

    @Nonnull
    public final HttpClientSettings setUseDNSClientCache(boolean bl) {
        this.m_bUseDNSClientCache = bl;
        return this;
    }

    @Override
    @Nullable
    public final SSLContext getSSLContext() {
        return this.m_aSSLContext;
    }

    @Nonnull
    public final HttpClientSettings setSSLContext(@Nullable SSLContext sSLContext) {
        this.m_aSSLContext = sSLContext;
        return this;
    }

    @Nonnull
    public final HttpClientSettings setSSLContextTrustAll() throws GeneralSecurityException {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, new TrustManager[]{new TrustManagerTrustAll(false)}, null);
        return this.setSSLContext(sSLContext);
    }

    @Override
    @Nullable
    public final HostnameVerifier getHostnameVerifier() {
        return this.m_aHostnameVerifier;
    }

    @Nonnull
    public final HttpClientSettings setHostnameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
        this.m_aHostnameVerifier = hostnameVerifier;
        return this;
    }

    @Nonnull
    public final HttpClientSettings setHostnameVerifierVerifyAll() {
        return this.setHostnameVerifier(new HostnameVerifierVerifyAll(false));
    }

    @Override
    @Nullable
    public final ITLSConfigurationMode getTLSConfigurationMode() {
        return this.m_aTLSConfigurationMode;
    }

    @Nonnull
    public final HttpClientSettings setTLSConfigurationMode(@Nullable ITLSConfigurationMode iTLSConfigurationMode) {
        this.m_aTLSConfigurationMode = iTLSConfigurationMode;
        return this;
    }

    @Override
    @Nullable
    public final HttpHost getProxyHost() {
        return this.m_aProxyHost;
    }

    @Nonnull
    public final HttpClientSettings setProxyHost(@Nullable HttpHost httpHost) {
        this.m_aProxyHost = httpHost;
        if (httpHost != null && this.m_bUseSystemProperties) {
            LOGGER.warn("Since an explicit Proxy host for is defined, the usage of the system properties is disabled.");
            this.m_bUseSystemProperties = false;
        }
        return this;
    }

    @Override
    @Nullable
    public final Credentials getProxyCredentials() {
        return this.m_aProxyCredentials;
    }

    @Nonnull
    public final HttpClientSettings setProxyCredentials(@Nullable Credentials credentials) {
        this.m_aProxyCredentials = credentials;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsOrderedSet<String> nonProxyHosts() {
        return this.m_aNonProxyHosts;
    }

    @Nonnull
    public final HttpClientSettings addNonProxyHostsFromPipeString(@Nullable String string2) {
        if (StringHelper.hasText(string2)) {
            StringHelper.explode('|', string2, string -> {
                String string2 = string.trim();
                if (StringHelper.hasText(string2)) {
                    this.m_aNonProxyHosts.add(string2);
                }
            });
        }
        return this;
    }

    @Override
    @Nonnegative
    public final int getRetryCount() {
        return this.m_nRetryCount;
    }

    @Nonnull
    public final HttpClientSettings setRetryCount(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Retries");
        this.m_nRetryCount = n;
        return this;
    }

    @Override
    @Nonnull
    public final HttpClientRetryHandler.ERetryMode getRetryMode() {
        return this.m_eRetryMode;
    }

    @Nonnull
    public final HttpClientSettings setRetryMode(@Nonnull HttpClientRetryHandler.ERetryMode eRetryMode) {
        ValueEnforcer.notNull(eRetryMode, "RetryMode");
        this.m_eRetryMode = eRetryMode;
        return this;
    }

    @Override
    public final int getConnectionRequestTimeoutMS() {
        return this.m_nConnectionRequestTimeoutMS;
    }

    @Nonnull
    public final HttpClientSettings setConnectionRequestTimeoutMS(int n) {
        this.m_nConnectionRequestTimeoutMS = n;
        return this;
    }

    @Override
    public final int getConnectionTimeoutMS() {
        return this.m_nConnectionTimeoutMS;
    }

    @Nonnull
    public final HttpClientSettings setConnectionTimeoutMS(int n) {
        this.m_nConnectionTimeoutMS = n;
        return this;
    }

    @Override
    public final int getSocketTimeoutMS() {
        return this.m_nSocketTimeoutMS;
    }

    @Nonnull
    public final HttpClientSettings setSocketTimeoutMS(int n) {
        this.m_nSocketTimeoutMS = n;
        return this;
    }

    @Override
    @Nullable
    public final String getUserAgent() {
        return this.m_sUserAgent;
    }

    @Nonnull
    public final HttpClientSettings setUserAgent(@Nullable String string) {
        this.m_sUserAgent = string;
        return this;
    }

    @Override
    public final boolean isFollowRedirects() {
        return this.m_bFollowRedirects;
    }

    @Nonnull
    public final HttpClientSettings setFollowRedirects(boolean bl) {
        this.m_bFollowRedirects = bl;
        return this;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public HttpClientSettings getClone() {
        return new HttpClientSettings(this);
    }

    public String toString() {
        return new ToStringGenerator(this).append("UseSystemProperties", this.m_bUseSystemProperties).append("UseDNSClientCache", this.m_bUseDNSClientCache).append("SSLContext", this.m_aSSLContext).append("TLSConfigurationMode", this.m_aTLSConfigurationMode).append("HostnameVerifier", this.m_aHostnameVerifier).append("ProxyHost", this.m_aProxyHost).append("ProxyCredentials", this.m_aProxyCredentials).append("NonProxyHosts", this.m_aNonProxyHosts).append("RetryCount", this.m_nRetryCount).append("RetryMode", this.m_eRetryMode).append("ConnectionRequestTimeoutMS", this.m_nConnectionRequestTimeoutMS).append("ConnectionTimeoutMS", this.m_nConnectionTimeoutMS).append("SocketTimeoutMS", this.m_nSocketTimeoutMS).append("UserAgent", this.m_sUserAgent).append("FollowRedirects", this.m_bFollowRedirects).getToString();
    }
}

