/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.protocol.HttpContext;

public class HttpClientRetryHandler
implements HttpRequestRetryHandler {
    private final int m_nMaxRetries;
    private final ERetryMode m_eRetryMode;

    public HttpClientRetryHandler(@Nonnegative int n, @Nonnull ERetryMode eRetryMode) {
        ValueEnforcer.isGE0(n, "MaxRetries");
        ValueEnforcer.notNull(eRetryMode, "RetryMode");
        this.m_nMaxRetries = n;
        this.m_eRetryMode = eRetryMode;
    }

    @Nonnegative
    public final int getMaxRetries() {
        return this.m_nMaxRetries;
    }

    @Nonnull
    public final ERetryMode getRetryMode() {
        return this.m_eRetryMode;
    }

    @Override
    public boolean retryRequest(IOException iOException, int n, HttpContext httpContext) {
        if (n >= this.m_nMaxRetries) {
            return false;
        }
        if (this.m_eRetryMode.isCheckException()) {
            if (iOException instanceof InterruptedIOException) {
                return false;
            }
            if (iOException instanceof UnknownHostException) {
                return false;
            }
            if (iOException instanceof ConnectTimeoutException) {
                return false;
            }
            if (iOException instanceof SSLException) {
                return false;
            }
        }
        switch (this.m_eRetryMode) {
            case RETRY_ALWAYS: 
            case RETRY_SMART: {
                return true;
            }
            case RETRY_IDEMPOTENT_ONLY: {
                boolean bl;
                HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
                HttpRequest httpRequest = httpClientContext.getRequest();
                boolean bl2 = bl = !(httpRequest instanceof HttpEntityEnclosingRequest);
                return bl;
            }
        }
        throw new IllegalStateException("Unsupported retry mode: " + (Object)((Object)this.m_eRetryMode));
    }

    public String toString() {
        return new ToStringGenerator(this).append("MaxRetries", this.m_nMaxRetries).append("RetryMode", this.m_eRetryMode).getToString();
    }

    public static enum ERetryMode {
        RETRY_ALWAYS,
        RETRY_SMART,
        RETRY_IDEMPOTENT_ONLY;


        public boolean isCheckException() {
            return this == RETRY_SMART || this == RETRY_IDEMPOTENT_ONLY;
        }
    }
}

