/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.http.tls.ITLSConfigurationMode;
import com.helger.httpclient.HttpClientRetryHandler;
import com.helger.httpclient.HttpClientSettings;
import com.helger.httpclient.IHttpClientProvider;
import com.helger.httpclient.NonCachingDnsResolver;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.RequestAddCookies;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HttpClientFactory
implements IHttpClientProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientFactory.class);
    private final HttpClientSettings m_aSettings;

    public HttpClientFactory() {
        this(new HttpClientSettings());
    }

    public HttpClientFactory(@Nonnull HttpClientSettings httpClientSettings) {
        ValueEnforcer.notNull(httpClientSettings, "Settings");
        this.m_aSettings = httpClientSettings;
    }

    @Nonnull
    public SchemePortResolver createSchemePortResolver() {
        return DefaultSchemePortResolver.INSTANCE;
    }

    @Nullable
    public LayeredConnectionSocketFactory createSSLFactory() {
        SSLConnectionSocketFactory sSLConnectionSocketFactory = null;
        try {
            SSLContext sSLContext = this.m_aSettings.getSSLContext();
            if (sSLContext != null) {
                HostnameVerifier hostnameVerifier;
                ITLSConfigurationMode iTLSConfigurationMode = this.m_aSettings.getTLSConfigurationMode();
                if (iTLSConfigurationMode == null) {
                    iTLSConfigurationMode = HttpClientSettings.DEFAULT_TLS_CONFIG_MODE;
                }
                if ((hostnameVerifier = this.m_aSettings.getHostnameVerifier()) == null) {
                    hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using the following TLS versions: " + iTLSConfigurationMode.getAllTLSVersionIDs());
                    LOGGER.debug("Using the following TLS cipher suites: " + iTLSConfigurationMode.getAllCipherSuites());
                    LOGGER.debug("Using the following hostname verifier: " + hostnameVerifier);
                }
                sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sSLContext, iTLSConfigurationMode.getAllTLSVersionIDsAsArray(), iTLSConfigurationMode.getAllCipherSuitesAsArray(), hostnameVerifier);
            }
        }
        catch (SSLInitializationException sSLInitializationException) {
            LOGGER.warn("Failed to init custom SSLConnectionSocketFactory - falling back to default SSLConnectionSocketFactory", sSLInitializationException);
        }
        if (sSLConnectionSocketFactory == null) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Trying SSLConnectionSocketFactory.getSystemSocketFactory ()");
                }
                sSLConnectionSocketFactory = SSLConnectionSocketFactory.getSystemSocketFactory();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using SSL socket factory with an SSL context based on system propertiesas described in JSSE Reference Guide.");
                }
            }
            catch (SSLInitializationException sSLInitializationException) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Trying SSLConnectionSocketFactory.getSocketFactory ()");
                    }
                    sSLConnectionSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Using SSL socket factory with an SSL context based on the standard JSSEtrust material (cacerts file in the security properties directory).System properties are not taken into consideration.");
                    }
                }
                catch (SSLInitializationException sSLInitializationException2) {
                    // empty catch block
                }
            }
        }
        return sSLConnectionSocketFactory;
    }

    @Nonnull
    public ConnectionConfig.Builder createConnectionConfigBuilder() {
        return ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(StandardCharsets.UTF_8);
    }

    @Nonnull
    public ConnectionConfig createConnectionConfig() {
        return this.createConnectionConfigBuilder().build();
    }

    @Nullable
    public DnsResolver createDNSResolver() {
        return this.m_aSettings.isUseDNSClientCache() ? SystemDefaultDnsResolver.INSTANCE : NonCachingDnsResolver.INSTANCE;
    }

    @Nonnull
    public HttpClientConnectionManager createConnectionManager(@Nonnull LayeredConnectionSocketFactory layeredConnectionSocketFactory) {
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)layeredConnectionSocketFactory)).build();
        DnsResolver dnsResolver = this.createDNSResolver();
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(registry, dnsResolver);
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(100);
        poolingHttpClientConnectionManager.setMaxTotal(200);
        poolingHttpClientConnectionManager.setValidateAfterInactivity(1000);
        ConnectionConfig connectionConfig = this.createConnectionConfig();
        poolingHttpClientConnectionManager.setDefaultConnectionConfig(connectionConfig);
        return poolingHttpClientConnectionManager;
    }

    @Nonnull
    public RequestConfig.Builder createRequestConfigBuilder() {
        return RequestConfig.custom().setCookieSpec("default").setConnectionRequestTimeout(this.m_aSettings.getConnectionRequestTimeoutMS()).setConnectTimeout(this.m_aSettings.getConnectionTimeoutMS()).setSocketTimeout(this.m_aSettings.getSocketTimeoutMS()).setCircularRedirectsAllowed(false).setRedirectsEnabled(this.m_aSettings.isFollowRedirects());
    }

    @Nonnull
    public RequestConfig createRequestConfig() {
        return this.createRequestConfigBuilder().build();
    }

    @Nullable
    public CredentialsProvider createCredentialsProvider() {
        HttpHost httpHost = this.m_aSettings.getProxyHost();
        Credentials credentials = this.m_aSettings.getProxyCredentials();
        if (httpHost != null && credentials != null) {
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(new AuthScope(httpHost), credentials);
            return basicCredentialsProvider;
        }
        return null;
    }

    @Nullable
    public HttpRequestRetryHandler createRequestRetryHandler(@Nonnegative int n, @Nonnull HttpClientRetryHandler.ERetryMode eRetryMode) {
        return new HttpClientRetryHandler(n, eRetryMode);
    }

    @Nonnull
    public HttpClientBuilder createHttpClientBuilder() {
        Object object;
        LayeredConnectionSocketFactory layeredConnectionSocketFactory = this.createSSLFactory();
        if (layeredConnectionSocketFactory == null) {
            throw new IllegalStateException("Failed to create SSL SocketFactory");
        }
        SchemePortResolver schemePortResolver = this.createSchemePortResolver();
        HttpClientConnectionManager httpClientConnectionManager = this.createConnectionManager(layeredConnectionSocketFactory);
        RequestConfig requestConfig = this.createRequestConfig();
        HttpHost httpHost = this.m_aSettings.getProxyHost();
        CredentialsProvider credentialsProvider = this.createCredentialsProvider();
        DefaultRoutePlanner defaultRoutePlanner = null;
        if (httpHost != null) {
            if (this.m_aSettings.nonProxyHosts().isEmpty()) {
                defaultRoutePlanner = new DefaultProxyRoutePlanner(httpHost, schemePortResolver);
            } else {
                object = this.m_aSettings.nonProxyHosts().getClone();
                defaultRoutePlanner = new DefaultRoutePlanner(schemePortResolver, (ICommonsSet)object, httpHost){
                    final /* synthetic */ ICommonsSet val$aNonProxyHosts;
                    final /* synthetic */ HttpHost val$aProxyHost;
                    {
                        this.val$aNonProxyHosts = iCommonsSet;
                        this.val$aProxyHost = httpHost;
                        super(schemePortResolver);
                    }

                    @Override
                    protected HttpHost determineProxy(@Nonnull HttpHost httpHost, @Nonnull HttpRequest httpRequest, @Nonnull HttpContext httpContext) throws HttpException {
                        String string = httpHost.getHostName();
                        if (this.val$aNonProxyHosts.contains(string)) {
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info("Not using proxy host for route to '" + string + "'");
                            }
                            return null;
                        }
                        return this.val$aProxyHost;
                    }
                };
            }
        }
        object = HttpClients.custom().setSchemePortResolver(schemePortResolver).setConnectionManager(httpClientConnectionManager).setDefaultRequestConfig(requestConfig).setDefaultCredentialsProvider(credentialsProvider).setRoutePlanner(defaultRoutePlanner);
        ((HttpClientBuilder)object).addInterceptorLast(new RequestAcceptEncoding());
        ((HttpClientBuilder)object).addInterceptorLast(new RequestAddCookies());
        ((HttpClientBuilder)object).addInterceptorLast(new ResponseContentEncoding());
        if (this.m_aSettings.isUseSystemProperties()) {
            ((HttpClientBuilder)object).useSystemProperties();
        }
        if (this.m_aSettings.hasRetries()) {
            ((HttpClientBuilder)object).setRetryHandler(this.createRequestRetryHandler(this.m_aSettings.getRetryCount(), this.m_aSettings.getRetryMode()));
        }
        if (this.m_aSettings.hasUserAgent()) {
            ((HttpClientBuilder)object).setUserAgent(this.m_aSettings.getUserAgent());
        }
        return object;
    }

    @Override
    @Nonnull
    public CloseableHttpClient createHttpClient() {
        HttpClientBuilder httpClientBuilder = this.createHttpClientBuilder();
        return httpClientBuilder.build();
    }
}

