/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.csp;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.util.ABNF;
import com.helger.http.csp.CSP2SourceList;
import com.helger.http.csp.ICSPDirective;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CSP2Directive
implements ICSPDirective {
    private final String m_sName;
    private final String m_sValue;

    public static boolean isValidName(@Nullable String string) {
        char[] cArray;
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        for (char c : cArray = string.toCharArray()) {
            if (ABNF.isAlpha(c) || ABNF.isDigit(c) || c == '-') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidValue(@Nullable String string) {
        char[] cArray;
        if (StringHelper.hasNoText(string)) {
            return true;
        }
        for (char c : cArray = string.toCharArray()) {
            if (ABNF.isWSP(c) || ABNF.isVChar(c) && c != ';' && c != ',') continue;
            return false;
        }
        return true;
    }

    public CSP2Directive(@Nonnull @Nonempty String string, @Nullable CSP2SourceList cSP2SourceList) {
        this(string, cSP2SourceList == null ? null : cSP2SourceList.getAsString());
    }

    public CSP2Directive(@Nonnull @Nonempty String string, @Nullable String string2) {
        ValueEnforcer.isTrue(CSP2Directive.isValidName(string), () -> "The CSP directive name '" + string + "' is invalid!");
        ValueEnforcer.isTrue(CSP2Directive.isValidValue(string2), () -> "The CSP directive value '" + string2 + "' is invalid!");
        this.m_sName = string;
        this.m_sValue = string2;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sName;
    }

    @Override
    @Nullable
    public final String getValue() {
        return this.m_sValue;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSP2Directive cSP2Directive = (CSP2Directive)object;
        return this.m_sName.equals(cSP2Directive.m_sName) && EqualsHelper.equals(this.m_sValue, cSP2Directive.m_sValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sName).append(this.m_sValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("name", this.m_sName).appendIfNotNull("value", this.m_sValue).getToString();
    }

    @Nonnull
    public static CSP2Directive createDefaultSrc(@Nullable CSP2SourceList cSP2SourceList) {
        return new CSP2Directive("default-src", cSP2SourceList);
    }

    @Nonnull
    public static CSP2Directive createScriptSrc(@Nullable CSP2SourceList cSP2SourceList) {
        return new CSP2Directive("script-src", cSP2SourceList);
    }

    @Nonnull
    public static CSP2Directive createStyleSrc(@Nullable CSP2SourceList cSP2SourceList) {
        return new CSP2Directive("style-src", cSP2SourceList);
    }

    @Nonnull
    public static CSP2Directive createImgSrc(@Nullable CSP2SourceList cSP2SourceList) {
        return new CSP2Directive("img-src", cSP2SourceList);
    }

    @Nonnull
    public static CSP2Directive createConnectSrc(@Nullable CSP2SourceList cSP2SourceList) {
        return new CSP2Directive("connect-src", cSP2SourceList);
    }

    @Nonnull
    public static CSP2Directive createFontSrc(@Nullable CSP2SourceList cSP2SourceList) {
        return new CSP2Directive("font-src", cSP2SourceList);
    }

    @Nonnull
    public static CSP2Directive createObjectSrc(@Nullable CSP2SourceList cSP2SourceList) {
        return new CSP2Directive("object-src", cSP2SourceList);
    }

    @Nonnull
    public static CSP2Directive createMediaSrc(@Nullable CSP2SourceList cSP2SourceList) {
        return new CSP2Directive("media-src", cSP2SourceList);
    }

    @Nonnull
    public static CSP2Directive createSandbox(@Nullable String string) {
        return new CSP2Directive("sandbox", string);
    }

    @Nonnull
    public static CSP2Directive createReportURI(@Nullable String string) {
        return new CSP2Directive("report-uri", string);
    }

    @Nonnull
    public static CSP2Directive createChildSrc(@Nullable CSP2SourceList cSP2SourceList) {
        return new CSP2Directive("child-src", cSP2SourceList);
    }

    @Nonnull
    public static CSP2Directive createFormAction(@Nullable CSP2SourceList cSP2SourceList) {
        return new CSP2Directive("form-action", cSP2SourceList);
    }

    @Nonnull
    public static CSP2Directive createFrameAncestors(@Nullable CSP2SourceList cSP2SourceList) {
        return new CSP2Directive("frame-ancestors", cSP2SourceList);
    }

    @Nonnull
    public static CSP2Directive createPluginTypes(@Nullable CSP2SourceList cSP2SourceList) {
        return new CSP2Directive("plugin-types", cSP2SourceList);
    }
}

