/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.csp;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.http.csp.ICSPDirective;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractCSPPolicy<T extends ICSPDirective>
implements Serializable {
    private final ICommonsList<T> m_aList = new CommonsArrayList<T>();

    public boolean isEmpty() {
        return this.m_aList.isEmpty();
    }

    public boolean isNotEmpty() {
        return this.m_aList.isNotEmpty();
    }

    @Nonnegative
    public int getDirectiveCount() {
        return this.m_aList.size();
    }

    @Nonnull
    public AbstractCSPPolicy<T> addDirective(@Nonnull T t) {
        ValueEnforcer.notNull(t, "Directive");
        this.m_aList.add(t);
        return this;
    }

    @Nonnull
    public EChange removeDirective(@Nullable T t) {
        return this.m_aList.removeObject(t);
    }

    @Nonnull
    public EChange removeDirectiveAtIndex(int n) {
        return this.m_aList.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllDirectives() {
        return this.m_aList.removeAll();
    }

    @Nonnull
    public String getAsString() {
        return StringHelper.getImplodedMappedNonEmpty("; ", this.m_aList, ICSPDirective::getAsStringIfHasValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractCSPPolicy abstractCSPPolicy = (AbstractCSPPolicy)object;
        return this.m_aList.equals(abstractCSPPolicy.m_aList);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aList)).getHashCode();
    }

    @Nonnull
    public String toString() {
        return new ToStringGenerator(this).append("list", this.m_aList).getToString();
    }
}

