/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.basicauth;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.base64.Base64;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.http.basicauth.HttpBasicAuth;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class BasicAuthClientCredentials
implements Serializable {
    private final String m_sUserName;
    private final String m_sPassword;

    public BasicAuthClientCredentials(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public BasicAuthClientCredentials(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_sUserName = ValueEnforcer.notEmpty(string, "UserName");
        this.m_sPassword = StringHelper.hasNoText(string2) ? null : string2;
    }

    @Nonnull
    @Nonempty
    public String getUserName() {
        return this.m_sUserName;
    }

    @Nullable
    public String getPassword() {
        return this.m_sPassword;
    }

    public boolean hasPassword() {
        return this.m_sPassword != null;
    }

    @Nonnull
    @Nonempty
    public String getRequestValue() {
        String string = StringHelper.getConcatenatedOnDemand(this.m_sUserName, ':', this.m_sPassword);
        return "Basic " + Base64.safeEncode(string, HttpBasicAuth.CHARSET);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BasicAuthClientCredentials basicAuthClientCredentials = (BasicAuthClientCredentials)object;
        return this.m_sUserName.equals(basicAuthClientCredentials.m_sUserName) && EqualsHelper.equals(this.m_sPassword, basicAuthClientCredentials.m_sPassword);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sUserName).append(this.m_sPassword).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("userName", this.m_sUserName).appendPassword("password").getToString();
    }
}

