/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class HttpStringHelper {
    public static final int MIN_INDEX = 0;
    public static final int MAX_INDEX = 127;
    public static final char COMMENT_BEGIN = '(';
    public static final char COMMENT_END = ')';
    public static final char QUOTEDTEXT_BEGIN = '\"';
    public static final char QUOTEDTEXT_END = '\"';
    public static final int CHAR_TAB = 9;
    public static final int CHAR_LF = 10;
    public static final int CHAR_CR = 13;
    public static final int CHAR_SPACE = 32;
    private static final int UALPHA = 1;
    private static final int LALPHA = 2;
    private static final int ALPHA = 4;
    private static final int DIGIT = 8;
    private static final int CTL = 16;
    private static final int LWS = 32;
    private static final int HEX = 64;
    private static final int LHEX = 128;
    private static final int NON_TOKEN = 256;
    private static final int NON_TEXT = 512;
    private static final int NON_COMMENT = 1024;
    private static final int NON_QUOTEDTEXT = 2048;
    private static final int RESERVED = 4096;
    private static final int EXTRA = 8192;
    private static final int SAFE = 16384;
    private static final int UNSAFE = 32768;
    private static final char[] MAPPINGS = new char[]{'\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8130', '\u8030', '\u8210', '\u8210', '\u8030', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8210', '\u8120', '\u2000', '\u8900', '\u8000', '\u4000', '\u8000', '\u1000', '\u2000', '\u2500', '\u2500', '\u2000', '\u1000', '\u2100', '\u4000', '\u4000', '\u1100', '\u00c8', '\u00c8', '\u00c8', '\u00c8', '\u00c8', '\u00c8', '\u00c8', '\u00c8', '\u00c8', '\u00c8', '\u1100', '\u1100', '\u8100', '\u1100', '\u8100', '\u1100', '\u1100', 'E', 'E', 'E', 'E', 'E', 'E', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0100', '\u0100', '\u0100', '\u0000', '\u4000', '\u0000', '\u00c6', '\u00c6', '\u00c6', '\u00c6', '\u00c6', '\u00c6', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0100', '\u0000', '\u0100', '\u0000', '\u8210'};
    private static final HttpStringHelper s_aInstance;

    private HttpStringHelper() {
    }

    public static boolean isChar(int n) {
        return n >= 0 && n <= 127;
    }

    public static boolean isOctet(int n) {
        return n >= 0 && n < 256;
    }

    public static boolean isUpperAlphaChar(int n) {
        return HttpStringHelper.isChar(n) && (MAPPINGS[n] & '\u0001') == 1;
    }

    public static boolean isLowerAlphaChar(int n) {
        return HttpStringHelper.isChar(n) && (MAPPINGS[n] & 2) == 2;
    }

    public static boolean isAlphaChar(int n) {
        return HttpStringHelper.isChar(n) && (MAPPINGS[n] & 4) == 4;
    }

    public static boolean isDigitChar(int n) {
        return HttpStringHelper.isChar(n) && (MAPPINGS[n] & 8) == 8;
    }

    public static boolean isControlChar(int n) {
        return HttpStringHelper.isChar(n) && (MAPPINGS[n] & 0x10) == 16;
    }

    public static boolean isCRChar(int n) {
        return n == 13;
    }

    public static boolean isLFChar(int n) {
        return n == 10;
    }

    public static boolean isSpaceChar(int n) {
        return n == 32;
    }

    public static boolean isTabChar(int n) {
        return n == 9;
    }

    public static boolean isLinearWhitespaceChar(int n) {
        return HttpStringHelper.isChar(n) && (MAPPINGS[n] & 0x20) == 32;
    }

    public static boolean isQuoteChar(int n) {
        return n == 34;
    }

    public static boolean isHexChar(int n) {
        return HttpStringHelper.isChar(n) && (MAPPINGS[n] & 0x40) == 64;
    }

    public static boolean isHexNotEmpty(@Nullable char[] cArray) {
        if (ArrayHelper.isEmpty(cArray)) {
            return false;
        }
        for (char c : cArray) {
            if (HttpStringHelper.isHexChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isHexNotEmpty(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        return HttpStringHelper.isHexNotEmpty(string.toCharArray());
    }

    public static boolean isLowerHexChar(int n) {
        return HttpStringHelper.isChar(n) && (MAPPINGS[n] & 0x80) == 128;
    }

    public static boolean isLowerHexNotEmpty(@Nullable char[] cArray) {
        if (ArrayHelper.isEmpty(cArray)) {
            return false;
        }
        for (char c : cArray) {
            if (HttpStringHelper.isLowerHexChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerHexNotEmpty(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        return HttpStringHelper.isLowerHexNotEmpty(string.toCharArray());
    }

    public static boolean isNonTokenChar(int n) {
        return HttpStringHelper.isChar(n) && (MAPPINGS[n] & 0x100) == 256;
    }

    public static boolean isTokenChar(int n) {
        return HttpStringHelper.isChar(n) && (MAPPINGS[n] & 0x110) == 0;
    }

    public static boolean isToken(@Nullable char[] cArray) {
        if (ArrayHelper.isEmpty(cArray)) {
            return false;
        }
        for (char c : cArray) {
            if (HttpStringHelper.isTokenChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isToken(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        return HttpStringHelper.isToken(string.toCharArray());
    }

    public static boolean isTextChar(int n) {
        if (n < 0) {
            return false;
        }
        if (n > 127) {
            return n < 256;
        }
        return (MAPPINGS[n] & 0x200) == 0;
    }

    public static boolean isCommentChar(int n) {
        if (n < 0) {
            return false;
        }
        if (n > 127) {
            return n < 256;
        }
        return (MAPPINGS[n] & 0x600) == 0;
    }

    public static boolean isComment(@Nullable char[] cArray) {
        if (ArrayHelper.getSize(cArray) < 2 || cArray[0] != '(' || cArray[cArray.length - 1] != ')') {
            return false;
        }
        for (int i = 1; i < cArray.length - 1; ++i) {
            if (HttpStringHelper.isCommentChar(cArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isComment(@Nullable String string) {
        if (StringHelper.getLength(string) < 2) {
            return false;
        }
        return HttpStringHelper.isComment(string.toCharArray());
    }

    public static boolean isQuotedTextChar(int n) {
        return HttpStringHelper.isChar(n) && (MAPPINGS[n] & 0xA00) == 0;
    }

    public static boolean isQuotedText(@Nullable char[] cArray) {
        if (ArrayHelper.getSize(cArray) < 2 || cArray[0] != '\"' || cArray[cArray.length - 1] != '\"') {
            return false;
        }
        for (int i = 1; i < cArray.length - 1; ++i) {
            if (HttpStringHelper.isQuotedTextChar(cArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isQuotedText(@Nullable String string) {
        if (StringHelper.getLength(string) < 2) {
            return false;
        }
        return HttpStringHelper.isQuotedText(string.toCharArray());
    }

    @Nullable
    public static String getQuotedTextString(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return '\"' + string + '\"';
    }

    public static boolean isQuotedTextContent(@Nullable char[] cArray) {
        if (cArray == null) {
            return false;
        }
        for (char c : cArray) {
            if (HttpStringHelper.isQuotedTextChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isQuotedTextContent(@Nullable String string) {
        if (string == null) {
            return false;
        }
        return HttpStringHelper.isQuotedTextContent(string.toCharArray());
    }

    public static boolean isWord(@Nullable char[] cArray) {
        return HttpStringHelper.isToken(cArray) || HttpStringHelper.isQuotedText(cArray);
    }

    public static boolean isWord(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        return HttpStringHelper.isWord(string.toCharArray());
    }

    public static boolean isReservedChar(int n) {
        return HttpStringHelper.isChar(n) && (MAPPINGS[n] & 0x1000) == 4096;
    }

    public static boolean isExtraChar(int n) {
        return HttpStringHelper.isChar(n) && (MAPPINGS[n] & 0x2000) == 8192;
    }

    public static boolean isSafeChar(int n) {
        return HttpStringHelper.isChar(n) && (MAPPINGS[n] & 0x4000) == 16384;
    }

    public static boolean isUnsafeChar(int n) {
        return HttpStringHelper.isChar(n) && (MAPPINGS[n] & 0x8000) == 32768;
    }

    public static boolean isNationalChar(int n) {
        if (n < 0) {
            return false;
        }
        if (n > 127) {
            return n < 256;
        }
        return (MAPPINGS[n] & 0xF00C) == 0;
    }

    public static boolean isUnreservedChar(int n) {
        if (n < 0) {
            return false;
        }
        if (n > 127) {
            return n < 256;
        }
        char c = MAPPINGS[n];
        return (c & 0xF00C) == 0 || (c & 0x600C) != 0;
    }

    static {
        if (MAPPINGS.length != 128) {
            throw new InitializationException("MAPPING array is invalid!");
        }
        s_aInstance = new HttpStringHelper();
    }
}

