/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.commons.codec.DecodeException;
import com.helger.commons.codec.RFC2616Codec;
import com.helger.commons.mime.EMimeContentType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.mime.MimeTypeParserException;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.http.AcceptMimeTypeList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class AcceptMimeTypeHandler {
    public static final IMimeType ANY_MIMETYPE = new MimeType(EMimeContentType._STAR, "*");
    private static final Logger LOGGER = LoggerFactory.getLogger(AcceptMimeTypeHandler.class);
    private static final AcceptMimeTypeHandler s_aInstance = new AcceptMimeTypeHandler();

    private AcceptMimeTypeHandler() {
    }

    @Nonnull
    public static AcceptMimeTypeList getAcceptMimeTypes(@Nullable String string) {
        AcceptMimeTypeList acceptMimeTypeList = new AcceptMimeTypeList();
        if (StringHelper.hasNoText(string)) {
            acceptMimeTypeList.addMimeType(ANY_MIMETYPE, 1.0);
        } else {
            for (String string2 : StringHelper.getExploded(',', string)) {
                String string3;
                IMimeType iMimeType;
                String[] stringArray = StringHelper.getExplodedArray(';', string2.trim(), 2);
                double d = 1.0;
                if (stringArray.length == 2 && stringArray[1].trim().startsWith("q=")) {
                    d = StringParser.parseDouble(stringArray[1].trim().substring(2), 1.0);
                }
                if ((iMimeType = AcceptMimeTypeHandler.safeParseMimeType(string3 = stringArray[0])) != null) {
                    if (iMimeType.hasAnyParameters()) {
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn("Ignoring all contained MIME type parameter from '" + string3 + "'!");
                        }
                        iMimeType = iMimeType.getCopyWithoutParameters();
                    }
                    acceptMimeTypeList.addMimeType(iMimeType, d);
                    continue;
                }
                if ("*".equals(string3)) {
                    acceptMimeTypeList.addMimeType(ANY_MIMETYPE, d);
                    continue;
                }
                if ("xml/xml".equals(string3) || !LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("Failed to parse Mime type '" + string3 + "' as part of '" + string + "'!");
            }
        }
        return acceptMimeTypeList;
    }

    @Nullable
    public static IMimeType safeParseMimeType(@Nullable String string) {
        String string2 = string;
        if (RFC2616Codec.isMaybeEncoded(string2)) {
            try {
                string2 = new RFC2616Codec().getDecodedAsString(string2);
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
        }
        try {
            return MimeTypeParser.parseMimeType(string2);
        }
        catch (MimeTypeParserException mimeTypeParserException) {
            if ("*".equals(string2)) {
                return new MimeType(EMimeContentType._STAR, "*");
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Unparsable MIME type '" + string + "'");
            }
            return null;
        }
    }
}

