/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dns.resolve;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.dns.config.DNSConfig;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SimpleResolver;

@Immutable
public final class ResolverHelper {
    private ResolverHelper() {
    }

    public static void defaultCustomizeResolver(@Nonnull Resolver resolver) {
        resolver.setTimeout(DNSConfig.getResolverTimeout());
    }

    public static void defaultCustomizeExtendedResolver(@Nonnull ExtendedResolver extendedResolver) {
        ResolverHelper.defaultCustomizeResolver(extendedResolver);
        extendedResolver.setRetries(DNSConfig.getResolverRetries());
    }

    public static void forEachDefaultResolver(@Nonnull Consumer<? super SimpleResolver> consumer) {
        ValueEnforcer.notNull(consumer, "Consumer");
        for (InetSocketAddress inetSocketAddress : ResolverConfig.getCurrentConfig().servers()) {
            if (inetSocketAddress == null) continue;
            SimpleResolver simpleResolver = new SimpleResolver(inetSocketAddress);
            ResolverHelper.defaultCustomizeResolver(simpleResolver);
            consumer.accept(simpleResolver);
        }
    }

    public static void forEachResolver(@Nullable Iterable<? extends InetAddress> iterable, @Nonnull Consumer<? super SimpleResolver> consumer) {
        if (iterable != null) {
            for (InetAddress inetAddress : iterable) {
                if (inetAddress == null) continue;
                SimpleResolver simpleResolver = new SimpleResolver(inetAddress);
                ResolverHelper.defaultCustomizeResolver(simpleResolver);
                consumer.accept(simpleResolver);
            }
        }
    }

    private static boolean _isContained(ICommonsList<Resolver> iCommonsList, SimpleResolver simpleResolver) {
        InetSocketAddress inetSocketAddress = simpleResolver.getAddress();
        return iCommonsList.containsAny(resolver -> ((SimpleResolver)resolver).getAddress().equals(inetSocketAddress));
    }

    @Nonnull
    public static ExtendedResolver createExtendedResolver(@Nullable Iterable<? extends InetAddress> iterable) {
        CommonsArrayList<Resolver> commonsArrayList = new CommonsArrayList<Resolver>();
        ResolverHelper.forEachResolver(iterable, simpleResolver -> {
            if (!ResolverHelper._isContained(commonsArrayList, simpleResolver)) {
                commonsArrayList.add(simpleResolver);
            }
        });
        ResolverHelper.forEachDefaultResolver(simpleResolver -> {
            if (!ResolverHelper._isContained(commonsArrayList, simpleResolver)) {
                commonsArrayList.add(simpleResolver);
            }
        });
        ResolverHelper.forEachResolver(DNSConfig.getDefaultCustomServers(), simpleResolver -> {
            if (!ResolverHelper._isContained(commonsArrayList, simpleResolver)) {
                commonsArrayList.add(simpleResolver);
            }
        });
        ExtendedResolver extendedResolver = new ExtendedResolver(commonsArrayList);
        ResolverHelper.defaultCustomizeExtendedResolver(extendedResolver);
        return extendedResolver;
    }

    static {
        DNSConfig.ensureInited();
    }
}

