/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dns.ip;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IPV4Addr
implements Serializable {
    public static final String PATTERN_IPV4 = "\\b((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.|$)){4}\\b";
    public static final int PARTS = 4;
    public static final int PART_MIN_VALUE = 0;
    public static final int PART_MAX_VALUE = 255;
    private final int m_nIP0;
    private final int m_nIP1;
    private final int m_nIP2;
    private final int m_nIP3;

    @Nonnegative
    private static int _validatePart(@Nonnegative int n) {
        return ValueEnforcer.isBetweenInclusive(n, "IP part", 0, 255);
    }

    public IPV4Addr(@Nonnull InetAddress inetAddress) {
        this(inetAddress.getAddress());
    }

    public IPV4Addr(@Nonnull byte[] byArray) {
        this(byArray[0] & 0xFF, byArray[1] & 0xFF, byArray[2] & 0xFF, byArray[3] & 0xFF);
    }

    public IPV4Addr(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4) {
        this.m_nIP0 = IPV4Addr._validatePart(n);
        this.m_nIP1 = IPV4Addr._validatePart(n2);
        this.m_nIP2 = IPV4Addr._validatePart(n3);
        this.m_nIP3 = IPV4Addr._validatePart(n4);
    }

    @Nonnull
    @ReturnsMutableCopy
    public int[] getNumberParts() {
        return ArrayHelper.newIntArray(this.m_nIP0, this.m_nIP1, this.m_nIP2, this.m_nIP3);
    }

    @Nonnull
    private static InetAddress _getAsInetAddress(int n, int n2, int n3, int n4) {
        try {
            return InetAddress.getByAddress(new byte[]{(byte)(n & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 & 0xFF), (byte)(n4 & 0xFF)});
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalStateException("Ooops", unknownHostException);
        }
    }

    @Nonnull
    public static InetAddress getAsInetAddress(int n, int n2, int n3, int n4) {
        return IPV4Addr._getAsInetAddress(IPV4Addr._validatePart(n), IPV4Addr._validatePart(n2), IPV4Addr._validatePart(n3), IPV4Addr._validatePart(n4));
    }

    @Nonnull
    public InetAddress getAsInetAddress() {
        return IPV4Addr._getAsInetAddress(this.m_nIP0, this.m_nIP1, this.m_nIP2, this.m_nIP3);
    }

    @Nonnull
    public String getAsString() {
        return new StringBuilder(15).append(this.m_nIP0).append('.').append(this.m_nIP1).append('.').append(this.m_nIP2).append('.').append(this.m_nIP3).toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        IPV4Addr iPV4Addr = (IPV4Addr)object;
        return this.m_nIP0 == iPV4Addr.m_nIP0 && this.m_nIP1 == iPV4Addr.m_nIP1 && this.m_nIP2 == iPV4Addr.m_nIP2 && this.m_nIP3 == iPV4Addr.m_nIP3;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nIP0).append(this.m_nIP1).append(this.m_nIP2).append(this.m_nIP3).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ip0", this.m_nIP0).append("ip1", this.m_nIP1).append("ip2", this.m_nIP2).append("ip3", this.m_nIP3).getToString();
    }

    private static int _parsePart(@Nullable String string) {
        return StringParser.parseInt(string, -1);
    }

    @Nonnull
    public static IPV4Addr parse(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Text");
        String[] stringArray = StringHelper.getExplodedArray('.', string);
        if (stringArray.length != 4) {
            throw new IllegalArgumentException("Expected exactly 4 parts");
        }
        return new IPV4Addr(IPV4Addr._parsePart(stringArray[0]), IPV4Addr._parsePart(stringArray[1]), IPV4Addr._parsePart(stringArray[2]), IPV4Addr._parsePart(stringArray[3]));
    }
}

