/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dns.dnsjava;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.dns.dnsjava.CustomServerConfigProvider;
import java.net.InetAddress;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.config.AndroidResolverConfigProvider;
import org.xbill.DNS.config.JndiContextResolverConfigProvider;
import org.xbill.DNS.config.PropertyResolverConfigProvider;
import org.xbill.DNS.config.ResolvConfResolverConfigProvider;
import org.xbill.DNS.config.ResolverConfigProvider;
import org.xbill.DNS.config.SunJvmResolverConfigProvider;
import org.xbill.DNS.config.WindowsResolverConfigProvider;

@Immutable
public final class DnsjavaInit {
    private static final Logger LOGGER = LoggerFactory.getLogger(DnsjavaInit.class);

    private DnsjavaInit() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ResolverConfigProvider> getDefaultResolverConfigProviders() {
        CommonsArrayList<ResolverConfigProvider> commonsArrayList = new CommonsArrayList<ResolverConfigProvider>();
        commonsArrayList.add(new PropertyResolverConfigProvider());
        commonsArrayList.add(new ResolvConfResolverConfigProvider());
        commonsArrayList.add(new WindowsResolverConfigProvider());
        commonsArrayList.add(new AndroidResolverConfigProvider());
        commonsArrayList.add(new JndiContextResolverConfigProvider());
        commonsArrayList.add(new SunJvmResolverConfigProvider());
        return commonsArrayList;
    }

    public static void initWithCustomDNSServers(@Nonnull @Nonempty ICommonsList<InetAddress> iCommonsList) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, "CustomDNSServers");
        ICommonsList<ResolverConfigProvider> iCommonsList2 = DnsjavaInit.getDefaultResolverConfigProviders();
        iCommonsList2.add(CustomServerConfigProvider.createFromInetAddressList(iCommonsList));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Overwriting dnsjava default ResolverConfiguration. Adding the following custom DNS servers: " + iCommonsList);
        }
        ResolverConfig.setConfigProviders(iCommonsList2);
    }

    public static void detDefaultConfig() {
        ICommonsList<ResolverConfigProvider> iCommonsList = DnsjavaInit.getDefaultResolverConfigProviders();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Setting dnsjava default ResolverConfiguration.");
        }
        ResolverConfig.setConfigProviders(iCommonsList);
    }
}

