/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.source;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.config.source.IConfigurationSource;
import com.helger.config.value.ConfiguredValue;
import com.helger.config.value.IConfigurationValueProvider;
import com.helger.config.value.IConfigurationValueProviderWithPriorityCallback;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiConfigurationValueProvider
implements IConfigurationValueProvider,
ICloneable<MultiConfigurationValueProvider> {
    public static final boolean DEFAULT_USE_ONLY_INTIIALIZED_CONFIG_SOURCES = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiConfigurationValueProvider.class);
    private final ICommonsList<CS> m_aSources = new CommonsArrayList<CS>();
    private boolean m_bUseOnlyInitializedConfigSources = true;

    public MultiConfigurationValueProvider() {
    }

    public MultiConfigurationValueProvider(@Nullable List<? extends IConfigurationSource> list) {
        if (list != null) {
            for (IConfigurationSource iConfigurationSource : list) {
                this.addConfigurationSource(iConfigurationSource);
            }
        }
    }

    public MultiConfigurationValueProvider(IConfigurationSource ... iConfigurationSourceArray) {
        if (iConfigurationSourceArray != null) {
            for (IConfigurationSource iConfigurationSource : iConfigurationSourceArray) {
                this.addConfigurationSource(iConfigurationSource);
            }
        }
    }

    public final boolean isUseOnlyInitializedConfigSources() {
        return this.m_bUseOnlyInitializedConfigSources;
    }

    @Nonnull
    public final MultiConfigurationValueProvider setUseOnlyInitializedConfigSources(boolean bl) {
        this.m_bUseOnlyInitializedConfigSources = bl;
        return this;
    }

    @Nonnull
    public final MultiConfigurationValueProvider addConfigurationSource(@Nonnull IConfigurationSource iConfigurationSource) {
        ValueEnforcer.notNull(iConfigurationSource, "ConfigSource");
        if (this.m_bUseOnlyInitializedConfigSources && !iConfigurationSource.isInitializedAndUsable()) {
            return this;
        }
        return this.addConfigurationSource(iConfigurationSource, iConfigurationSource.getPriority());
    }

    @Nonnull
    public final MultiConfigurationValueProvider addConfigurationSource(@Nullable IConfigurationValueProvider iConfigurationValueProvider, int n) {
        if (iConfigurationValueProvider != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding configuration source " + iConfigurationValueProvider + " with priority " + n);
            }
            this.m_aSources.add(new CS(iConfigurationValueProvider, n));
            this.m_aSources.sort((cS, cS2) -> ((CS)cS2).m_nPrio - ((CS)cS).m_nPrio);
        }
        return this;
    }

    @Nonnegative
    public final int getConfigurationSourceCount() {
        return this.m_aSources.size();
    }

    @Override
    @Nullable
    public ConfiguredValue getConfigurationValue(@Nonnull @Nonempty String string) {
        CS cS;
        ConfiguredValue configuredValue = null;
        Iterator iterator2 = this.m_aSources.iterator();
        while (iterator2.hasNext() && (configuredValue = (cS = (CS)iterator2.next()).m_aCVP.getConfigurationValue(string)) == null) {
        }
        return configuredValue;
    }

    public void forEachConfigurationValueProvider(@Nonnull IConfigurationValueProviderWithPriorityCallback iConfigurationValueProviderWithPriorityCallback) {
        ValueEnforcer.notNull(iConfigurationValueProviderWithPriorityCallback, "aCallback");
        for (CS cS : this.m_aSources) {
            iConfigurationValueProviderWithPriorityCallback.onConfigurationSource(cS.m_aCVP, cS.m_nPrio);
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public MultiConfigurationValueProvider getClone() {
        MultiConfigurationValueProvider multiConfigurationValueProvider = new MultiConfigurationValueProvider();
        for (CS cS : this.m_aSources) {
            if (cS.m_aCVP instanceof ICloneable) {
                IConfigurationValueProvider iConfigurationValueProvider = (IConfigurationValueProvider)((ICloneable)((Object)cS.m_aCVP)).getClone();
                multiConfigurationValueProvider.m_aSources.add(new CS(iConfigurationValueProvider, cS.m_nPrio));
                continue;
            }
            multiConfigurationValueProvider.m_aSources.add(cS);
        }
        return multiConfigurationValueProvider;
    }

    @Nullable
    public static MultiConfigurationValueProvider createForClassPath(@Nonnull ClassLoader classLoader, @Nonnull String string, @Nonnull Function<URL, IConfigurationSource> function) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notNull(string, "ClassPathElement");
        ValueEnforcer.notNull(function, "Loader");
        MultiConfigurationValueProvider multiConfigurationValueProvider = new MultiConfigurationValueProvider();
        try {
            Enumeration<URL> enumeration = ClassLoaderHelper.getResources(classLoader, string);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                IConfigurationSource iConfigurationSource = function.apply(uRL);
                if (iConfigurationSource == null) {
                    throw new IllegalStateException("Failed to load configration source " + uRL);
                }
                multiConfigurationValueProvider.addConfigurationSource(iConfigurationSource);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        if (multiConfigurationValueProvider.getConfigurationSourceCount() == 0) {
            return null;
        }
        return multiConfigurationValueProvider;
    }

    private static final class CS {
        private final IConfigurationValueProvider m_aCVP;
        private final int m_nPrio;

        public CS(@Nonnull IConfigurationValueProvider iConfigurationValueProvider, int n) {
            this.m_aCVP = iConfigurationValueProvider;
            this.m_nPrio = n;
        }
    }
}

