/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config;

import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.IResourceBase;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.io.resourceprovider.ClassPathResourceProvider;
import com.helger.commons.io.resourceprovider.FileSystemResourceProvider;
import com.helger.commons.io.resourceprovider.ReadableResourceProviderChain;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.URLHelper;
import com.helger.config.Config;
import com.helger.config.IConfig;
import com.helger.config.source.EConfigSourceType;
import com.helger.config.source.IConfigurationSource;
import com.helger.config.source.MultiConfigurationValueProvider;
import com.helger.config.source.envvar.ConfigurationSourceEnvVar;
import com.helger.config.source.res.ConfigurationSourceJson;
import com.helger.config.source.res.ConfigurationSourceProperties;
import com.helger.config.source.res.EConfigSourceResourceType;
import com.helger.config.source.sysprop.ConfigurationSourceSystemProperty;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ConfigFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFactory.class);
    private static final EConfigSourceResourceType FALLBACK_SOURCE_TYPE = EConfigSourceResourceType.PROPERTIES;
    private static final IConfig SYSTEM_ONLY = Config.create(ConfigFactory.createValueProviderSystemOnly());
    private static final IConfig DEFAULT_INSTANCE = Config.create(ConfigFactory.createDefaultValueProvider());

    @Nonnull
    public static MultiConfigurationValueProvider createValueProviderSystemOnly() {
        MultiConfigurationValueProvider multiConfigurationValueProvider = new MultiConfigurationValueProvider();
        multiConfigurationValueProvider.addConfigurationSource(new ConfigurationSourceSystemProperty());
        multiConfigurationValueProvider.addConfigurationSource(new ConfigurationSourceEnvVar());
        return multiConfigurationValueProvider;
    }

    @Nonnull
    public static MultiConfigurationValueProvider createDefaultValueProvider() {
        int n;
        Object object;
        Object object2;
        MultiConfigurationValueProvider multiConfigurationValueProvider = new MultiConfigurationValueProvider();
        multiConfigurationValueProvider.addConfigurationSource(new ConfigurationSourceSystemProperty());
        multiConfigurationValueProvider.addConfigurationSource(new ConfigurationSourceEnvVar());
        int n2 = EConfigSourceType.RESOURCE.getDefaultPriority();
        Object object3 = SYSTEM_ONLY.getAsString("config.resource");
        if (StringHelper.hasText((String)object3)) {
            object2 = EConfigSourceResourceType.getFromExtensionOrDefault(FilenameHelper.getExtension((String)object3), FALLBACK_SOURCE_TYPE);
            object = new ClassPathResource((String)object3);
            if (((ClassPathResource)object).exists()) {
                n = SYSTEM_ONLY.getAsInt("config.resource.priority", n2);
                multiConfigurationValueProvider.addConfigurationSource(object2.createConfigurationSource((IReadableResource)object), n);
            }
        }
        if (StringHelper.hasText((String)(object3 = SYSTEM_ONLY.getAsString("config.resources")))) {
            int n3 = SYSTEM_ONLY.getAsInt("config.resources.priority", n2);
            object = EConfigSourceResourceType.getFromExtensionOrDefault(FilenameHelper.getExtension((String)object3), FALLBACK_SOURCE_TYPE);
            multiConfigurationValueProvider.addConfigurationSource(MultiConfigurationValueProvider.createForClassPath(ClassLoaderHelper.getDefaultClassLoader(), (String)object3, arg_0 -> ConfigFactory.lambda$createDefaultValueProvider$0((EConfigSourceResourceType)((Object)object), arg_0)), n3);
        }
        if (StringHelper.hasText((String)(object3 = SYSTEM_ONLY.getAsString("config.file")))) {
            object2 = EConfigSourceResourceType.getFromExtensionOrDefault(FilenameHelper.getExtension((String)object3), FALLBACK_SOURCE_TYPE);
            object = new FileSystemResource((String)object3);
            if (((FileSystemResource)object).exists()) {
                n = SYSTEM_ONLY.getAsInt("config.file.priority", n2);
                multiConfigurationValueProvider.addConfigurationSource(object2.createConfigurationSource((IReadableResource)object), n);
            }
        }
        if (StringHelper.hasText((String)(object3 = SYSTEM_ONLY.getAsString("config.url")))) {
            URLResource uRLResource;
            object2 = EConfigSourceResourceType.getFromExtensionOrDefault(FilenameHelper.getExtension((String)object3), FALLBACK_SOURCE_TYPE);
            object = URLHelper.getAsURL((String)object3);
            if (object != null && (uRLResource = new URLResource((URL)object)).exists()) {
                int n4 = SYSTEM_ONLY.getAsInt("config.url.priority", n2);
                multiConfigurationValueProvider.addConfigurationSource(object2.createConfigurationSource(uRLResource), n4);
            }
        }
        if ((object2 = ((ReadableResourceProviderChain)(object3 = new ReadableResourceProviderChain(new FileSystemResourceProvider().setCanReadRelativePaths(true), new ClassPathResourceProvider()))).getReadableResourceIf("private-application.json", IResourceBase::exists)) != null) {
            multiConfigurationValueProvider.addConfigurationSource(new ConfigurationSourceJson((IReadableResource)object2, StandardCharsets.UTF_8), n2 - 5);
        }
        if ((object2 = ((ReadableResourceProviderChain)object3).getReadableResourceIf("private-application.properties", IResourceBase::exists)) != null) {
            multiConfigurationValueProvider.addConfigurationSource(new ConfigurationSourceProperties((IReadableResource)object2, StandardCharsets.UTF_8), n2 - 10);
        }
        multiConfigurationValueProvider.addConfigurationSource(MultiConfigurationValueProvider.createForClassPath(ClassLoaderHelper.getDefaultClassLoader(), "application.json", uRL -> new ConfigurationSourceJson(new URLResource((URL)uRL), StandardCharsets.UTF_8)), n2 - 15);
        multiConfigurationValueProvider.addConfigurationSource(MultiConfigurationValueProvider.createForClassPath(ClassLoaderHelper.getDefaultClassLoader(), "application.properties", uRL -> new ConfigurationSourceProperties(new URLResource((URL)uRL), StandardCharsets.UTF_8)), n2 - 20);
        multiConfigurationValueProvider.addConfigurationSource(MultiConfigurationValueProvider.createForClassPath(ClassLoaderHelper.getDefaultClassLoader(), "reference.properties", uRL -> new ConfigurationSourceProperties(new URLResource((URL)uRL), StandardCharsets.UTF_8)), 1);
        return multiConfigurationValueProvider;
    }

    private ConfigFactory() {
    }

    @Nonnull
    public static IConfig getSystemConfig() {
        return SYSTEM_ONLY;
    }

    @Nonnull
    public static IConfig getDefaultConfig() {
        return DEFAULT_INSTANCE;
    }

    private static /* synthetic */ IConfigurationSource lambda$createDefaultValueProvider$0(EConfigSourceResourceType eConfigSourceResourceType, URL uRL) {
        return eConfigSourceResourceType.createConfigurationSource(new URLResource(uRL));
    }

    static {
        int n = DEFAULT_INSTANCE.getResourceBasedConfigurationValueProviderCount();
        if (n == 0) {
            LOGGER.warn("The default Config instance is based soley on system properties and environment variables. No configuration resources were found.");
        }
    }
}

