/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.StringHelper;
import com.helger.config.IConfig;
import com.helger.config.source.IConfigurationSource;
import com.helger.config.source.MultiConfigurationValueProvider;
import com.helger.config.value.ConfiguredValue;
import com.helger.config.value.IConfigurationValueProvider;
import com.helger.config.value.IConfigurationValueProviderWithPriorityCallback;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Config
implements IConfig {
    private final IConfigurationValueProvider m_aValueProvider;
    private BiConsumer<String, ConfiguredValue> m_aKeyFoundConsumer;
    private Consumer<String> m_aKeyNotFoundConsumer;

    public Config(@Nonnull IConfigurationValueProvider iConfigurationValueProvider) {
        ValueEnforcer.notNull(iConfigurationValueProvider, "ValueProvider");
        this.m_aValueProvider = iConfigurationValueProvider;
    }

    @Nonnull
    public final IConfigurationValueProvider getConfigurationValueProvider() {
        return this.m_aValueProvider;
    }

    @Nullable
    public final BiConsumer<String, ConfiguredValue> getFoundKeyConsumer() {
        return this.m_aKeyFoundConsumer;
    }

    @Nullable
    public final Config setFoundKeyConsumer(@Nullable BiConsumer<String, ConfiguredValue> biConsumer) {
        this.m_aKeyFoundConsumer = biConsumer;
        return this;
    }

    @Nullable
    public final Consumer<String> getKeyNotFoundConsumer() {
        return this.m_aKeyNotFoundConsumer;
    }

    @Nullable
    public final Config setKeyNotFoundConsumer(@Nullable Consumer<String> consumer) {
        this.m_aKeyNotFoundConsumer = consumer;
        return this;
    }

    @Override
    @Nullable
    public ConfiguredValue getConfiguredValue(@Nullable String string) {
        ConfiguredValue configuredValue = StringHelper.hasNoText(string) ? null : this.m_aValueProvider.getConfigurationValue(string);
        if (configuredValue != null) {
            if (this.m_aKeyFoundConsumer != null) {
                this.m_aKeyFoundConsumer.accept(string, configuredValue);
            }
        } else if (this.m_aKeyNotFoundConsumer != null) {
            this.m_aKeyNotFoundConsumer.accept(string);
        }
        return configuredValue;
    }

    @Nullable
    public String getValue(@Nullable String string) {
        ConfiguredValue configuredValue = this.getConfiguredValue(string);
        return configuredValue == null ? null : configuredValue.getValue();
    }

    public static void forEachConfigurationValueProviderRecursive(@Nonnull IConfigurationValueProvider iConfigurationValueProvider2, @Nonnull IConfigurationValueProviderWithPriorityCallback iConfigurationValueProviderWithPriorityCallback) {
        if (iConfigurationValueProvider2 instanceof MultiConfigurationValueProvider) {
            MultiConfigurationValueProvider multiConfigurationValueProvider = (MultiConfigurationValueProvider)iConfigurationValueProvider2;
            multiConfigurationValueProvider.forEachConfigurationValueProvider((iConfigurationValueProvider, n) -> Config.forEachConfigurationValueProviderRecursive(iConfigurationValueProvider, iConfigurationValueProviderWithPriorityCallback));
        } else {
            int n2 = 0;
            if (iConfigurationValueProvider2 instanceof IConfigurationSource) {
                IConfigurationSource iConfigurationSource = (IConfigurationSource)iConfigurationValueProvider2;
                n2 = iConfigurationSource.getPriority();
            }
            iConfigurationValueProviderWithPriorityCallback.onConfigurationSource(iConfigurationValueProvider2, n2);
        }
    }

    @Override
    public void forEachConfigurationValueProvider(@Nonnull IConfigurationValueProviderWithPriorityCallback iConfigurationValueProviderWithPriorityCallback) {
        ValueEnforcer.notNull(iConfigurationValueProviderWithPriorityCallback, "Callback");
        Config.forEachConfigurationValueProviderRecursive(this.m_aValueProvider, iConfigurationValueProviderWithPriorityCallback);
    }

    @Nonnull
    public static Config create(@Nonnull IConfigurationValueProvider iConfigurationValueProvider) {
        return new Config(iConfigurationValueProvider);
    }
}

