/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.priviledged.IPrivilegedAction;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ClassLoaderHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassLoaderHelper.class);
    private static final ClassLoaderHelper s_aInstance = new ClassLoaderHelper();

    private ClassLoaderHelper() {
    }

    @Nonnull
    public static ClassLoader getSystemClassLoader() {
        return IPrivilegedAction.getSystemClassLoader().invokeSafe();
    }

    @Nullable
    public static ClassLoader getContextClassLoader() {
        return IPrivilegedAction.getContextClassLoader().invokeSafe();
    }

    public static void setContextClassLoader(@Nonnull ClassLoader classLoader) {
        IPrivilegedAction.setContextClassLoader(classLoader).invokeSafe();
    }

    @Nullable
    public static ClassLoader getClassClassLoader(@Nonnull Class<?> clazz) {
        return IPrivilegedAction.getClassLoader(clazz).invokeSafe();
    }

    @Nullable
    public static ClassLoader getParentClassLoader(@Nonnull ClassLoader classLoader) {
        return IPrivilegedAction.classLoaderGetParent(classLoader).invokeSafe();
    }

    @Nonnull
    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = ClassLoaderHelper.getContextClassLoader();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (classLoader == null) {
            classLoader = ClassLoaderHelper.getClassClassLoader(ClassLoaderHelper.class);
        }
        return classLoader;
    }

    @Nonnull
    private static String _getPathWithoutLeadingSlash(@Nonnull @Nonempty String string) {
        return string.charAt(0) == '/' ? string.substring(1) : string;
    }

    @Nullable
    public static URL getResource(@Nonnull ClassLoader classLoader, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = ClassLoaderHelper._getPathWithoutLeadingSlash(string);
        try {
            return classLoader.getResource(string2);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.warn("Unexpected runtime exception gathering resource '" + string2 + "'", runtimeException);
            return null;
        }
    }

    @Nonnull
    public static Enumeration<URL> getResources(@Nonnull ClassLoader classLoader, @Nonnull @Nonempty String string) throws IOException {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = ClassLoaderHelper._getPathWithoutLeadingSlash(string);
        return classLoader.getResources(string2);
    }

    @Nullable
    public static InputStream getResourceAsStream(@Nonnull ClassLoader classLoader, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = ClassLoaderHelper._getPathWithoutLeadingSlash(string);
        InputStream inputStream = classLoader.getResourceAsStream(string2);
        return StreamHelper.checkForInvalidFilterInputStream(inputStream);
    }
}

