/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.hashcode;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.hashcode.HashCodeCalculator;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.hashcode.IHashCodeImplementationRegistrarSPI;
import com.helger.commons.hashcode.IHashCodeImplementationRegistry;
import com.helger.commons.io.file.FilenameHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@IsSPIImplementation
public final class DefaultHashCodeImplementationRegistrarSPI
implements IHashCodeImplementationRegistrarSPI {
    @Override
    public void registerHashCodeImplementations(@Nonnull IHashCodeImplementationRegistry iHashCodeImplementationRegistry) {
        iHashCodeImplementationRegistry.registerHashCodeImplementation(StringBuffer.class, stringBuffer -> stringBuffer.toString().hashCode());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(StringBuilder.class, stringBuilder -> stringBuilder.toString().hashCode());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Node.class, node -> {
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(node).append(node.getNodeType()).append(node.getNodeName()).append(node.getLocalName()).append(node.getNamespaceURI()).append(node.getPrefix()).append(node.getNodeValue());
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            hashCodeGenerator = hashCodeGenerator.append(n);
            for (int i = 0; i < n; ++i) {
                hashCodeGenerator = hashCodeGenerator.append(nodeList.item(i));
            }
            return hashCodeGenerator.getHashCode();
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(AtomicBoolean.class, atomicBoolean -> HashCodeCalculator.append(0, atomicBoolean.get()));
        iHashCodeImplementationRegistry.registerHashCodeImplementation(AtomicInteger.class, atomicInteger -> HashCodeCalculator.append(0, atomicInteger.get()));
        iHashCodeImplementationRegistry.registerHashCodeImplementation(AtomicLong.class, atomicLong -> HashCodeCalculator.append(0, atomicLong.get()));
        iHashCodeImplementationRegistry.registerHashCodeImplementation(boolean[].class, Arrays::hashCode);
        iHashCodeImplementationRegistry.registerHashCodeImplementation(byte[].class, Arrays::hashCode);
        iHashCodeImplementationRegistry.registerHashCodeImplementation(char[].class, Arrays::hashCode);
        iHashCodeImplementationRegistry.registerHashCodeImplementation(double[].class, Arrays::hashCode);
        iHashCodeImplementationRegistry.registerHashCodeImplementation(float[].class, Arrays::hashCode);
        iHashCodeImplementationRegistry.registerHashCodeImplementation(int[].class, Arrays::hashCode);
        iHashCodeImplementationRegistry.registerHashCodeImplementation(long[].class, Arrays::hashCode);
        iHashCodeImplementationRegistry.registerHashCodeImplementation(short[].class, Arrays::hashCode);
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Map.class, map -> {
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(map).append(map.size());
            Iterator iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator2.next();
                hashCodeGenerator = hashCodeGenerator.append(entry2.getKey()).append(entry2.getValue());
            }
            return hashCodeGenerator.getHashCode();
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Collection.class, collection -> {
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(collection).append(collection.size());
            for (Object e : collection) {
                hashCodeGenerator = hashCodeGenerator.append(e);
            }
            return hashCodeGenerator.getHashCode();
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(ArrayList.class, arrayList -> {
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(arrayList).append(arrayList.size());
            for (Object e : arrayList) {
                hashCodeGenerator = hashCodeGenerator.append(e);
            }
            return hashCodeGenerator.getHashCode();
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Iterator.class, iterator2 -> {
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(iterator2);
            while (iterator2.hasNext()) {
                hashCodeGenerator = hashCodeGenerator.append(iterator2.next());
            }
            return hashCodeGenerator.getHashCode();
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Enumeration.class, enumeration -> {
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(enumeration);
            while (enumeration.hasMoreElements()) {
                hashCodeGenerator = hashCodeGenerator.append(enumeration.nextElement());
            }
            return hashCodeGenerator.getHashCode();
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(File.class, file -> FilenameHelper.getCleanPath(file.getAbsoluteFile()).hashCode());
    }
}

