/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error.level;

import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.level.IHasErrorLevel;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public interface IHasErrorLevels<IMPLTYPE extends IHasErrorLevel>
extends ICommonsIterable<IMPLTYPE> {
    default public boolean containsOnlySuccess() {
        return this.containsOnly(IHasErrorLevel::isSuccess);
    }

    default public boolean containsAtLeastOneSuccess() {
        return this.containsAny(IHasErrorLevel::isSuccess);
    }

    default public boolean containsNoSuccess() {
        return this.containsNone(IHasErrorLevel::isSuccess);
    }

    @Nonnegative
    default public int getSuccessCount() {
        return this.getCount(IHasErrorLevel::isSuccess);
    }

    default public boolean containsOnlyFailure() {
        return this.containsOnly(IHasErrorLevel::isFailure);
    }

    default public boolean containsAtLeastOneFailure() {
        return this.containsAny(IHasErrorLevel::isFailure);
    }

    default public boolean containsNoFailure() {
        return this.containsNone(IHasErrorLevel::isFailure);
    }

    @Nonnegative
    default public int getFailureCount() {
        return this.getCount(IHasErrorLevel::isFailure);
    }

    default public boolean containsOnlyError() {
        return this.containsOnly(IHasErrorLevel::isError);
    }

    default public boolean containsAtLeastOneError() {
        return this.containsAny(IHasErrorLevel::isError);
    }

    default public boolean containsNoError() {
        return this.containsNone(IHasErrorLevel::isError);
    }

    @Nonnegative
    default public int getErrorCount() {
        return this.getCount(IHasErrorLevel::isError);
    }

    default public boolean containsAtLeastOneWarningOrError() {
        return this.containsAny(iHasErrorLevel -> iHasErrorLevel.getErrorLevel().isGE(EErrorLevel.WARN));
    }

    @Nonnull
    default public IErrorLevel getMostSevereErrorLevel() {
        IHasErrorLevel iHasErrorLevel;
        IErrorLevel iErrorLevel;
        IErrorLevel iErrorLevel2 = EErrorLevel.LOWEST;
        Iterator iterator2 = this.iterator();
        while (!(!iterator2.hasNext() || (iErrorLevel = (iHasErrorLevel = (IHasErrorLevel)iterator2.next()).getErrorLevel()).isGT(iErrorLevel2) && (iErrorLevel2 = iErrorLevel).isHighest())) {
        }
        return iErrorLevel2;
    }
}

