/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.equals;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.equals.EqualsImplementationRegistry;
import com.helger.commons.equals.IEqualsImplementation;
import com.helger.commons.equals.IEqualsImplementationRegistrarSPI;
import com.helger.commons.equals.IEqualsImplementationRegistry;
import com.helger.commons.io.file.FilenameHelper;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@IsSPIImplementation
public final class DefaultEqualsImplementationRegistrarSPI
implements IEqualsImplementationRegistrarSPI {
    @Override
    public void registerEqualsImplementations(@Nonnull IEqualsImplementationRegistry iEqualsImplementationRegistry) {
        iEqualsImplementationRegistry.registerEqualsImplementation(BigDecimal.class, (bigDecimal, bigDecimal2) -> bigDecimal.compareTo((BigDecimal)bigDecimal2) == 0);
        iEqualsImplementationRegistry.registerEqualsImplementation(Double.class, (d, d2) -> d.compareTo((Double)d2) == 0);
        iEqualsImplementationRegistry.registerEqualsImplementation(Float.class, (f, f2) -> f.compareTo((Float)f2) == 0);
        iEqualsImplementationRegistry.registerEqualsImplementation(StringBuffer.class, (stringBuffer, stringBuffer2) -> stringBuffer.toString().equals(stringBuffer2.toString()));
        iEqualsImplementationRegistry.registerEqualsImplementation(StringBuilder.class, (stringBuilder, stringBuilder2) -> stringBuilder.toString().equals(stringBuilder2.toString()));
        iEqualsImplementationRegistry.registerEqualsImplementation(Node.class, (node, node2) -> {
            if (node.getNodeType() != node2.getNodeType()) {
                return false;
            }
            if (!EqualsImplementationRegistry.areEqual(node.getNodeName(), node2.getNodeName())) {
                return false;
            }
            if (!EqualsImplementationRegistry.areEqual(node.getLocalName(), node2.getLocalName())) {
                return false;
            }
            if (!EqualsImplementationRegistry.areEqual(node.getNamespaceURI(), node2.getNamespaceURI())) {
                return false;
            }
            if (!EqualsImplementationRegistry.areEqual(node.getPrefix(), node2.getPrefix())) {
                return false;
            }
            if (!EqualsImplementationRegistry.areEqual(node.getNodeValue(), node2.getNodeValue())) {
                return false;
            }
            NodeList nodeList = node.getChildNodes();
            NodeList nodeList2 = node2.getChildNodes();
            int n = nodeList.getLength();
            if (n != nodeList2.getLength()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                Node node3;
                Node node4 = nodeList.item(i);
                if (EqualsImplementationRegistry.areEqual(node4, node3 = nodeList2.item(i))) continue;
                return false;
            }
            return true;
        });
        iEqualsImplementationRegistry.registerEqualsImplementation(URL.class, (uRL, uRL2) -> uRL.toExternalForm().equals(uRL2.toExternalForm()));
        iEqualsImplementationRegistry.registerEqualsImplementation(AtomicBoolean.class, (atomicBoolean, atomicBoolean2) -> atomicBoolean.get() == atomicBoolean2.get());
        iEqualsImplementationRegistry.registerEqualsImplementation(AtomicInteger.class, (atomicInteger, atomicInteger2) -> atomicInteger.get() == atomicInteger2.get());
        iEqualsImplementationRegistry.registerEqualsImplementation(AtomicLong.class, (atomicLong, atomicLong2) -> atomicLong.get() == atomicLong2.get());
        iEqualsImplementationRegistry.registerEqualsImplementation(boolean[].class, Arrays::equals);
        iEqualsImplementationRegistry.registerEqualsImplementation(byte[].class, Arrays::equals);
        iEqualsImplementationRegistry.registerEqualsImplementation(char[].class, Arrays::equals);
        iEqualsImplementationRegistry.registerEqualsImplementation(double[].class, Arrays::equals);
        iEqualsImplementationRegistry.registerEqualsImplementation(float[].class, Arrays::equals);
        iEqualsImplementationRegistry.registerEqualsImplementation(int[].class, Arrays::equals);
        iEqualsImplementationRegistry.registerEqualsImplementation(long[].class, Arrays::equals);
        iEqualsImplementationRegistry.registerEqualsImplementation(short[].class, Arrays::equals);
        iEqualsImplementationRegistry.registerEqualsImplementation(Map.class, (map, map2) -> {
            if (map.size() != map2.size()) {
                return false;
            }
            for (Map.Entry entry : map.entrySet()) {
                Object v;
                Object k = entry.getKey();
                Object v2 = entry.getValue();
                if (!(v2 == null ? map2.get(k) != null || !map2.containsKey(k) : !EqualsImplementationRegistry.areEqual(v2, v = map2.get(k)))) continue;
                return false;
            }
            return true;
        });
        iEqualsImplementationRegistry.registerEqualsImplementation(Collection.class, (collection, collection2) -> {
            if (collection.size() != collection2.size()) {
                return false;
            }
            Object[] objectArray = collection.toArray();
            Object[] objectArray2 = collection2.toArray();
            return EqualsImplementationRegistry.areEqual(objectArray, objectArray2);
        });
        iEqualsImplementationRegistry.registerEqualsImplementation(ArrayList.class, (arrayList, arrayList2) -> {
            if (arrayList.size() != arrayList2.size()) {
                return false;
            }
            Object[] objectArray = arrayList.toArray();
            Object[] objectArray2 = arrayList2.toArray();
            return EqualsImplementationRegistry.areEqual(objectArray, objectArray2);
        });
        iEqualsImplementationRegistry.registerEqualsImplementation(Iterator.class, (iterator2, iterator3) -> {
            while (iterator2.hasNext()) {
                Object e;
                if (!iterator3.hasNext()) {
                    return false;
                }
                Object e2 = iterator2.next();
                if (EqualsImplementationRegistry.areEqual(e2, e = iterator3.next())) continue;
                return false;
            }
            return !iterator3.hasNext();
        });
        iEqualsImplementationRegistry.registerEqualsImplementation(Enumeration.class, (enumeration, enumeration2) -> {
            while (enumeration.hasMoreElements()) {
                Object e;
                if (!enumeration2.hasMoreElements()) {
                    return false;
                }
                Object e2 = enumeration.nextElement();
                if (EqualsImplementationRegistry.areEqual(e2, e = enumeration2.nextElement())) continue;
                return false;
            }
            return !enumeration2.hasMoreElements();
        });
        iEqualsImplementationRegistry.registerEqualsImplementation(File.class, (file, file2) -> FilenameHelper.getCleanPath(file.getAbsoluteFile()).equals(FilenameHelper.getCleanPath(file2.getAbsoluteFile())));
        iEqualsImplementationRegistry.registerEqualsImplementation(Path.class, new IEqualsImplementation<Path>(){

            @Override
            public boolean areEqual(Path path, Path path2) {
                try {
                    return path.toRealPath(new LinkOption[0]).equals(path2.toRealPath(new LinkOption[0]));
                }
                catch (IOException iOException) {
                    return path.equals(path2);
                }
            }

            @Override
            public boolean implementationEqualsOverridesInterface() {
                return false;
            }
        });
        iEqualsImplementationRegistry.registerEqualsImplementation(Locale.class, (locale, locale2) -> locale.toString().equals(locale2.toString()));
        iEqualsImplementationRegistry.registerEqualsImplementation(PasswordAuthentication.class, (passwordAuthentication, passwordAuthentication2) -> EqualsHelper.equals(passwordAuthentication.getUserName(), passwordAuthentication2.getUserName()) && Arrays.equals(passwordAuthentication.getPassword(), passwordAuthentication2.getPassword()));
    }
}

