/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.concurrent.collector;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.concurrent.collector.IMutableConcurrentCollector;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.state.ESuccess;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractConcurrentCollector<DATATYPE>
implements IMutableConcurrentCollector<DATATYPE> {
    public static final int DEFAULT_MAX_QUEUE_SIZE = 100;
    public static final Object STOP_QUEUE_OBJECT = new Object();
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConcurrentCollector.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    protected final BlockingQueue<Object> m_aQueue;
    @GuardedBy(value="m_aRWLock")
    private boolean m_bStopTakingNewObjects = false;

    public AbstractConcurrentCollector(@Nonnegative int n) {
        this(new ArrayBlockingQueue<Object>(ValueEnforcer.isGT0(n, "MaxQueueSize")));
    }

    public AbstractConcurrentCollector(@Nonnull BlockingQueue<Object> blockingQueue) {
        ValueEnforcer.notNull(blockingQueue, "Queue");
        this.m_aQueue = blockingQueue;
    }

    @Override
    @Nonnull
    public final ESuccess queueObject(@Nonnull DATATYPE DATATYPE) {
        ValueEnforcer.notNull(DATATYPE, "Object");
        if (this.isStopped()) {
            throw new IllegalStateException("The queue is already stopped and does not take any more elements");
        }
        return this.m_aRWLock.writeLockedGet(() -> {
            try {
                this.m_aQueue.put(DATATYPE);
                return ESuccess.SUCCESS;
            }
            catch (InterruptedException interruptedException) {
                LOGGER.error("Failed to submit object to queue", interruptedException);
                Thread.currentThread().interrupt();
                return ESuccess.FAILURE;
            }
        });
    }

    @Override
    public boolean isQueueEmpty() {
        return this.m_aRWLock.readLockedBoolean(this.m_aQueue::isEmpty);
    }

    @Override
    @Nonnegative
    public final int getQueueLength() {
        return this.m_aRWLock.readLockedInt(this.m_aQueue::size);
    }

    @Override
    @Nonnull
    public final ESuccess stopQueuingNewObjects() {
        return this.m_aRWLock.writeLockedGet(() -> {
            try {
                this.m_aQueue.put(STOP_QUEUE_OBJECT);
                this.m_bStopTakingNewObjects = true;
                return ESuccess.SUCCESS;
            }
            catch (InterruptedException interruptedException) {
                LOGGER.error("Error stopping queue", interruptedException);
                Thread.currentThread().interrupt();
                return ESuccess.FAILURE;
            }
        });
    }

    @Override
    public final boolean isStopped() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bStopTakingNewObjects);
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<DATATYPE> drainQueue() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.m_aRWLock.writeLockedInt(() -> this.m_aQueue.drainTo(commonsArrayList));
        CommonsArrayList commonsArrayList2 = new CommonsArrayList();
        for (Object e : commonsArrayList) {
            if (!EqualsHelper.identityEqual(e, STOP_QUEUE_OBJECT)) {
                commonsArrayList2.add(GenericReflection.uncheckedCast(e));
                continue;
            }
            this.m_aRWLock.writeLockedBoolean(() -> this.m_aQueue.add(e));
        }
        return commonsArrayList2;
    }
}

