/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.functional.IPredicate;
import com.helger.commons.string.ToStringGenerator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FilterIterator<ELEMENTTYPE>
implements IIterableIterator<ELEMENTTYPE> {
    private final Iterator<? extends ELEMENTTYPE> m_aBaseIter;
    private final IPredicate<? super ELEMENTTYPE> m_aFilter;
    private ELEMENTTYPE m_aCurrent;
    private boolean m_bHasNext = false;

    public FilterIterator(@Nonnull IIterableIterator<? extends ELEMENTTYPE> iIterableIterator, @Nonnull IPredicate<? super ELEMENTTYPE> iPredicate) {
        this(iIterableIterator.iterator(), iPredicate);
    }

    public FilterIterator(@Nonnull Iterator<? extends ELEMENTTYPE> iterator2, @Nonnull IPredicate<? super ELEMENTTYPE> iPredicate) {
        this.m_aBaseIter = ValueEnforcer.notNull(iterator2, "BaseIterator");
        this.m_aFilter = ValueEnforcer.notNull(iPredicate, "Filter");
        this._gotoNextCurrent();
    }

    public FilterIterator(@Nonnull Iterable<? extends ELEMENTTYPE> iterable, @Nonnull IPredicate<? super ELEMENTTYPE> iPredicate) {
        ValueEnforcer.notNull(iterable, "BaseContainer");
        this.m_aBaseIter = iterable.iterator();
        this.m_aFilter = ValueEnforcer.notNull(iPredicate, "Filter");
        this._gotoNextCurrent();
    }

    @Nonnull
    public IPredicate<? super ELEMENTTYPE> getFilter() {
        return this.m_aFilter;
    }

    private void _gotoNextCurrent() {
        this.m_aCurrent = null;
        this.m_bHasNext = false;
        while (this.m_aBaseIter.hasNext()) {
            ELEMENTTYPE ELEMENTTYPE = this.m_aBaseIter.next();
            if (!this.m_aFilter.test(ELEMENTTYPE)) continue;
            this.m_aCurrent = ELEMENTTYPE;
            this.m_bHasNext = true;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        return this.m_bHasNext;
    }

    @Override
    @Nullable
    public ELEMENTTYPE next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ELEMENTTYPE ELEMENTTYPE = this.m_aCurrent;
        this._gotoNextCurrent();
        return ELEMENTTYPE;
    }

    @Override
    public void remove() {
        this.m_aBaseIter.remove();
    }

    public String toString() {
        return new ToStringGenerator(this).append("baseIter", this.m_aBaseIter).append("filter", this.m_aFilter).getToString();
    }
}

