/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import java.util.Enumeration;
import java.util.Iterator;
import javax.annotation.Nonnull;

public final class EnumerationFromIterator<ELEMENTTYPE>
implements Enumeration<ELEMENTTYPE> {
    private final Iterator<? extends ELEMENTTYPE> m_aIter;

    public EnumerationFromIterator(@Nonnull Iterable<? extends ELEMENTTYPE> iterable) {
        this(iterable.iterator());
    }

    public EnumerationFromIterator(@Nonnull Iterator<? extends ELEMENTTYPE> iterator2) {
        this.m_aIter = ValueEnforcer.notNull(iterator2, "Iterator");
    }

    @Override
    public boolean hasMoreElements() {
        return this.m_aIter.hasNext();
    }

    @Override
    public ELEMENTTYPE nextElement() {
        return this.m_aIter.next();
    }

    public String toString() {
        return new ToStringGenerator(this).append("iter", this.m_aIter).getToString();
    }

    @Nonnull
    public static <ELEMENTTYPE> EnumerationFromIterator<ELEMENTTYPE> create(@Nonnull Iterator<? extends ELEMENTTYPE> iterator2) {
        return new EnumerationFromIterator<ELEMENTTYPE>(iterator2);
    }

    @Nonnull
    public static <ELEMENTTYPE> EnumerationFromIterator<ELEMENTTYPE> create(@Nonnull Iterable<? extends ELEMENTTYPE> iterable) {
        return new EnumerationFromIterator<ELEMENTTYPE>(iterable);
    }
}

