/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.impl;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ICommonsOrderedSet<ELEMENTTYPE>
extends ICommonsSet<ELEMENTTYPE> {
    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public <T> ICommonsOrderedSet<T> createInstance() {
        return new CommonsLinkedHashSet();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedSet<ELEMENTTYPE> getAll(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return this.getClone();
        }
        ICommonsSet iCommonsSet = this.createInstance();
        this.findAll(predicate, ((ICommonsOrderedSet)iCommonsSet)::add);
        return iCommonsSet;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE> ICommonsOrderedSet<DSTTYPE> getAllMapped(@Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        ICommonsSet iCommonsSet = this.createInstance();
        this.findAllMapped(function, ((ICommonsOrderedSet)iCommonsSet)::add);
        return iCommonsSet;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE> ICommonsOrderedSet<DSTTYPE> getAllMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        ICommonsSet iCommonsSet = this.createInstance();
        this.findAllMapped(predicate, function, ((ICommonsOrderedSet)iCommonsSet)::add);
        return iCommonsSet;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE extends ELEMENTTYPE> ICommonsOrderedSet<DSTTYPE> getAllInstanceOf(@Nonnull Class<DSTTYPE> clazz) {
        ICommonsSet iCommonsSet = this.createInstance();
        this.findAllInstanceOf(clazz, ((ICommonsOrderedSet)iCommonsSet)::add);
        return iCommonsSet;
    }

    @Nullable
    default public ELEMENTTYPE getFirst() {
        return this.getFirst(null);
    }

    @Nullable
    default public ELEMENTTYPE getFirst(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return (ELEMENTTYPE)(this.isEmpty() ? ELEMENTTYPE : this.iterator().next());
    }

    @Nullable
    default public ELEMENTTYPE getLast() {
        return this.getLast(null);
    }

    @Nullable
    default public ELEMENTTYPE getLast(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return this.isEmpty() ? ELEMENTTYPE : CollectionHelper.getLastElement(this);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<ELEMENTTYPE> getClone();
}

