/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection;

import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.iterate.ArrayIterator;
import com.helger.commons.collection.iterate.CombinedIterator;
import com.helger.commons.collection.iterate.EmptyEnumeration;
import com.helger.commons.collection.iterate.EmptyIterator;
import com.helger.commons.collection.iterate.EnumerationFromIterator;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.collection.iterate.IterableIteratorFromEnumeration;
import com.helger.commons.collection.iterate.ReverseListIterator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class IteratorHelper {
    private IteratorHelper() {
    }

    public static boolean isEmpty(@Nullable Iterator<?> iterator2) {
        return iterator2 == null || !iterator2.hasNext();
    }

    public static boolean isEmpty(@Nullable IIterableIterator<?> iIterableIterator) {
        return iIterableIterator == null || !iIterableIterator.hasNext();
    }

    public static boolean isEmpty(@Nullable Enumeration<?> enumeration) {
        return enumeration == null || !enumeration.hasMoreElements();
    }

    public static boolean isNotEmpty(@Nullable Iterator<?> iterator2) {
        return iterator2 != null && iterator2.hasNext();
    }

    public static boolean isNotEmpty(@Nullable IIterableIterator<?> iIterableIterator) {
        return iIterableIterator != null && iIterableIterator.hasNext();
    }

    public static boolean isNotEmpty(@Nullable Enumeration<?> enumeration) {
        return enumeration != null && enumeration.hasMoreElements();
    }

    @Nonnegative
    public static int getSize(@Nullable IIterableIterator<?> iIterableIterator) {
        return iIterableIterator == null ? 0 : IteratorHelper.getSize(iIterableIterator.iterator());
    }

    @Nonnegative
    public static int getSize(@Nullable Iterator<?> iterator2) {
        int n = 0;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                iterator2.next();
                ++n;
            }
        }
        return n;
    }

    @Nonnegative
    public static int getSize(@Nullable Enumeration<?> enumeration) {
        int n = 0;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
        }
        return n;
    }

    @Nonnull
    public static <ELEMENTTYPE> IIterableIterator<ELEMENTTYPE> getIterator(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        return new IterableIteratorFromEnumeration<ELEMENTTYPE>(enumeration);
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getIterator(@Nullable Iterable<ELEMENTTYPE> iterable) {
        return iterable == null ? new EmptyIterator() : IteratorHelper.getIterator(iterable.iterator());
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getIterator(@Nullable Iterator<ELEMENTTYPE> emptyIterator) {
        return emptyIterator == null ? new EmptyIterator() : emptyIterator;
    }

    @Nonnull
    @SafeVarargs
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getIterator(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ArrayHelper.isEmpty(ELEMENTTYPEArray) ? new EmptyIterator() : new ArrayIterator<ELEMENTTYPE>(ELEMENTTYPEArray);
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getReverseIterator(@Nullable List<? extends ELEMENTTYPE> list) {
        if (CollectionHelper.isEmpty(list)) {
            return new EmptyIterator();
        }
        return new ReverseListIterator<ELEMENTTYPE>(list);
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getCombinedIterator(@Nullable Iterator<? extends ELEMENTTYPE> iterator2, @Nullable Iterator<? extends ELEMENTTYPE> iterator3) {
        return new CombinedIterator<ELEMENTTYPE>(iterator2, iterator3);
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEnumeration(@Nullable Iterable<ELEMENTTYPE> iterable) {
        return CollectionHelper.isEmpty(iterable) ? new EmptyEnumeration() : IteratorHelper.getEnumeration(iterable.iterator());
    }

    @Nonnull
    @SafeVarargs
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEnumeration(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return IteratorHelper.getEnumeration(IteratorHelper.getIterator(ELEMENTTYPEArray));
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEnumeration(@Nullable Iterator<ELEMENTTYPE> iterator2) {
        if (iterator2 == null) {
            return new EmptyEnumeration();
        }
        return new EnumerationFromIterator<ELEMENTTYPE>(iterator2);
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> Enumeration<Map.Entry<KEYTYPE, VALUETYPE>> getEnumeration(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        if (map == null) {
            return new EmptyEnumeration<Map.Entry<KEYTYPE, VALUETYPE>>();
        }
        return IteratorHelper.getEnumeration(map.entrySet());
    }
}

