/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class ArrayIteratorBoolean {
    private final boolean[] m_aArray;
    private int m_nIndex = 0;

    public ArrayIteratorBoolean(boolean ... blArray) {
        this(blArray, 0, blArray.length);
    }

    public ArrayIteratorBoolean(@Nonnull boolean[] blArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(blArray, n, n2);
        this.m_aArray = ArrayHelper.getCopy(blArray, n, n2);
    }

    public boolean hasNext() {
        return this.m_nIndex < this.m_aArray.length;
    }

    public boolean next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aArray[this.m_nIndex++];
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ArrayIteratorBoolean arrayIteratorBoolean = (ArrayIteratorBoolean)object;
        return EqualsHelper.equals(this.m_aArray, arrayIteratorBoolean.m_aArray) && this.m_nIndex == arrayIteratorBoolean.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("array", Arrays.toString(this.m_aArray)).append("index", this.m_nIndex).getToString();
    }
}

