/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.helper;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.iterate.IIterableIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class QueueHelper {
    private QueueHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(@Nonnegative int n) {
        return new PriorityQueue(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue() {
        return new PriorityQueue();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> PriorityQueue<DSTTYPE> newQueueMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (CollectionHelper.isEmpty(collection)) {
            return QueueHelper.newQueue(false);
        }
        PriorityQueue<int> priorityQueue = QueueHelper.newQueue(collection.size());
        for (SRCTYPE SRCTYPE : collection) {
            priorityQueue.add((int)function.apply(SRCTYPE));
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> PriorityQueue<DSTTYPE> newQueueMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (ArrayHelper.isEmpty(SRCTYPEArray)) {
            return QueueHelper.newQueue(false);
        }
        PriorityQueue<int> priorityQueue = QueueHelper.newQueue(SRCTYPEArray.length);
        for (SRCTYPE SRCTYPE : SRCTYPEArray) {
            priorityQueue.add((int)function.apply(SRCTYPE));
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(@Nonnull ELEMENTTYPE ELEMENTTYPE) {
        PriorityQueue<boolean> priorityQueue = QueueHelper.newQueue(true);
        priorityQueue.add((boolean)ELEMENTTYPE);
        return priorityQueue;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return QueueHelper.newQueue(false);
        }
        PriorityQueue<int> priorityQueue = QueueHelper.newQueue(ELEMENTTYPEArray.length);
        Collections.addAll(priorityQueue, ELEMENTTYPEArray);
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        PriorityQueue<ELEMENTTYPE> priorityQueue = QueueHelper.newQueue();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                priorityQueue.add(enumeration.nextElement());
            }
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(@Nullable Iterator<? extends ELEMENTTYPE> iterator2) {
        PriorityQueue<ELEMENTTYPE> priorityQueue = QueueHelper.newQueue();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                priorityQueue.add(iterator2.next());
            }
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        PriorityQueue<ELEMENTTYPE> priorityQueue = QueueHelper.newQueue();
        if (iterable != null) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                priorityQueue.add(ELEMENTTYPE);
            }
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return QueueHelper.newQueue(false);
        }
        return new PriorityQueue<ELEMENTTYPE>(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        if (CollectionHelper.isEmpty(collection)) {
            return QueueHelper.newQueue(false);
        }
        PriorityQueue<int> priorityQueue = QueueHelper.newQueue(collection.size());
        CollectionHelper.findAll(collection, predicate, priorityQueue::add);
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> PriorityQueue<ELEMENTTYPE> newQueue(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        if (iIterableIterator == null) {
            return QueueHelper.newQueue(false);
        }
        return QueueHelper.newQueue(iIterableIterator.iterator());
    }
}

