/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.engine.source;

import com.helger.bdve.engine.source.IValidationSourceXML;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.XMLHelper;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.transform.TransformSourceFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.Source;
import org.w3c.dom.Node;

public class ValidationSourceXML
implements IValidationSourceXML {
    private final String m_sSystemID;
    private final ISupplier<Node> m_aNodeFactory;
    private final boolean m_bPartialSource;
    private transient Node m_aNode;

    public ValidationSourceXML(@Nullable String string, @Nonnull Node node, boolean bl) {
        this(string, () -> node, bl);
        this.m_aNode = node;
    }

    public ValidationSourceXML(@Nullable String string, @Nonnull ISupplier<Node> iSupplier, boolean bl) {
        ValueEnforcer.notNull(iSupplier, "NodeFactory");
        this.m_sSystemID = string;
        this.m_aNodeFactory = iSupplier;
        this.m_bPartialSource = bl;
    }

    @Override
    @Nullable
    public String getSystemID() {
        return this.m_sSystemID;
    }

    @Override
    @Nullable
    public Node getNode() {
        Node node = this.m_aNode;
        if (node == null) {
            node = this.m_aNode = (Node)this.m_aNodeFactory.get();
        }
        return node;
    }

    @Override
    public boolean isPartialSource() {
        return this.m_bPartialSource;
    }

    public String toString() {
        return new ToStringGenerator(this).append("SystemID", this.m_sSystemID).append("NodeFactory", this.m_aNodeFactory).append("PartialSource", this.m_bPartialSource).getToString();
    }

    @Nonnull
    public static ValidationSourceXML create(@Nullable String string, @Nonnull Node node) {
        ValueEnforcer.notNull(node, "Node");
        return new ValidationSourceXML(string, XMLHelper.getOwnerDocument(node), false);
    }

    @Nonnull
    public static ValidationSourceXML createPartial(@Nullable String string, @Nonnull Node node) {
        ValueEnforcer.notNull(node, "Node");
        return new ValidationSourceXML(string, node, true);
    }

    @Nonnull
    public static ValidationSourceXML create(final @Nonnull IReadableResource iReadableResource) {
        return new ValidationSourceXML(iReadableResource.getPath(), () -> DOMReader.readXMLDOM(iReadableResource), false){

            @Override
            @Nonnull
            public Source getAsTransformSource() {
                return TransformSourceFactory.create(iReadableResource);
            }
        };
    }
}

