/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.engine.schematron;

import com.helger.bdve.api.artefact.IValidationArtefact;
import com.helger.bdve.api.execute.AbstractValidationExecutor;
import com.helger.bdve.api.execute.IValidationExecutor;
import com.helger.bdve.api.result.ValidationResult;
import com.helger.bdve.engine.source.IValidationSourceXML;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.location.SimpleLocation;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.AbstractSchematronResource;
import com.helger.schematron.SchematronResourceHelper;
import com.helger.schematron.pure.SchematronResourcePure;
import com.helger.schematron.pure.errorhandler.WrappedCollectingPSErrorHandler;
import com.helger.schematron.svrl.SVRLFailedAssert;
import com.helger.schematron.svrl.SVRLHelper;
import com.helger.schematron.svrl.SVRLMarshaller;
import com.helger.schematron.svrl.SVRLResourceError;
import com.helger.schematron.svrl.SVRLSuccessfulReport;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.schematron.xslt.AbstractSchematronXSLTBasedResource;
import com.helger.schematron.xslt.SchematronResourceSCH;
import com.helger.schematron.xslt.SchematronResourceXSLT;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.XMLHelper;
import com.helger.xml.namespace.IIterableNamespaceContext;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import com.helger.xml.serialize.read.DOMReaderSettings;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.transform.WrappedCollectingTransformErrorListener;
import com.helger.xml.xpath.XPathExpressionHelper;
import com.helger.xml.xpath.XPathHelper;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ValidationExecutorSchematron
extends AbstractValidationExecutor<IValidationSourceXML, ValidationExecutorSchematron>
implements IValidationExecutor.ICacheSupport {
    public static final String IN_MEMORY_RESOURCE_NAME = "in-memory-data";
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationExecutorSchematron.class);
    private final String m_sPrerequisiteXPath;
    private final MapBasedNamespaceContext m_aNamespaceContext;
    private boolean m_bCacheSchematron = true;

    public ValidationExecutorSchematron(@Nonnull IValidationArtefact iValidationArtefact, @Nullable String string, @Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        super(iValidationArtefact);
        ValueEnforcer.isTrue(iValidationArtefact.getValidationArtefactType().isSchematron(), "Artifact is not a Schematron");
        this.m_sPrerequisiteXPath = string;
        this.m_aNamespaceContext = iIterableNamespaceContext == null ? null : new MapBasedNamespaceContext(iIterableNamespaceContext);
    }

    @Nullable
    public final String getPrerequisiteXPath() {
        return this.m_sPrerequisiteXPath;
    }

    @Nullable
    @ReturnsMutableObject
    public final MapBasedNamespaceContext getNamespaceContext() {
        return this.m_aNamespaceContext == null ? null : this.m_aNamespaceContext.getClone();
    }

    @Override
    public final boolean isCacheArtefact() {
        return this.m_bCacheSchematron;
    }

    @Override
    @Nonnull
    public final ValidationExecutorSchematron setCacheArtefact(boolean bl) {
        this.m_bCacheSchematron = bl;
        return this;
    }

    @Override
    @Nonnull
    public ValidationResult applyValidation(@Nonnull IValidationSourceXML iValidationSourceXML, @Nullable Locale locale) {
        Object object;
        Object object2;
        Object object3;
        ValueEnforcer.notNull(iValidationSourceXML, "Source");
        IValidationArtefact iValidationArtefact = this.getValidationArtefact();
        IReadableResource iReadableResource = iValidationArtefact.getRuleResource();
        Node node = null;
        try {
            node = SchematronResourceHelper.getNodeOfSource(iValidationSourceXML.getAsTransformSource(), new DOMReaderSettings().setFeatureValues(EXMLParserFeature.AVOID_XML_ATTACKS));
        }
        catch (Exception exception) {
            throw new IllegalStateException("For Schematron validation to work, the source must be valid XML which it is not.", exception);
        }
        if (StringHelper.hasText(this.m_sPrerequisiteXPath)) {
            object3 = XPathHelper.createNewXPath();
            if (this.m_aNamespaceContext != null) {
                object3.setNamespaceContext(this.m_aNamespaceContext);
            }
            try {
                object2 = XPathExpressionHelper.evalXPathToBoolean((XPath)object3, this.m_sPrerequisiteXPath, XMLHelper.getOwnerDocument(node));
                if (object2 != null && !((Boolean)object2).booleanValue()) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Ignoring validation artefact " + iReadableResource.getPath() + " because the prerequisite XPath expression '" + this.m_sPrerequisiteXPath + "' is not fulfilled.");
                    }
                    return ValidationResult.createIgnoredResult(iValidationArtefact);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = "Failed to verify if validation artefact " + iReadableResource.getPath() + " matches the prerequisite XPath expression '" + this.m_sPrerequisiteXPath + "' - ignoring validation artefact.";
                LOGGER.error(string, illegalArgumentException);
                return new ValidationResult(iValidationArtefact, new ErrorList(new IError[]{((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builderError().setErrorText(string)).setLinkedException(illegalArgumentException)).build()}));
            }
        }
        object3 = new ErrorList();
        ESchematronOutput eSchematronOutput = ESchematronOutput.SVRL;
        switch (this.getValidationArtefact().getValidationArtefactType()) {
            case SCHEMATRON_PURE: {
                object = new SchematronResourcePure(iReadableResource);
                ((SchematronResourcePure)object).setErrorHandler(new WrappedCollectingPSErrorHandler((ErrorList)object3));
                object2 = object;
                break;
            }
            case SCHEMATRON_SCH: {
                object = new SchematronResourceSCH(iReadableResource);
                ((AbstractSchematronXSLTBasedResource)object).setErrorListener(new WrappedCollectingTransformErrorListener((ErrorList)object3));
                if (locale != null && StringHelper.hasText(locale.getLanguage())) {
                    ((SchematronResourceSCH)object).setLanguageCode(locale.getLanguage());
                }
                object2 = object;
                break;
            }
            case SCHEMATRON_XSLT: {
                object = new SchematronResourceXSLT(iReadableResource);
                ((AbstractSchematronXSLTBasedResource)object).setErrorListener(new WrappedCollectingTransformErrorListener((ErrorList)object3));
                object2 = object;
                break;
            }
            case SCHEMATRON_OIOUBL: {
                object = new SchematronResourceXSLT(iReadableResource);
                ((AbstractSchematronXSLTBasedResource)object).setErrorListener(new WrappedCollectingTransformErrorListener((ErrorList)object3));
                object2 = object;
                eSchematronOutput = ESchematronOutput.OIOUBL;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported validation type: " + this.getValidationArtefact().getValidationArtefactType());
            }
        }
        ((AbstractSchematronResource)object2).setUseCache(this.m_bCacheSchematron);
        try {
            object = ((AbstractSchematronResource)object2).applySchematronValidation(new DOMSource(node));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SVRL: " + XMLWriter.getNodeAsString((Node)object));
            }
            switch (eSchematronOutput) {
                case SVRL: {
                    SchematronOutputType schematronOutputType;
                    SchematronOutputType schematronOutputType2 = schematronOutputType = object == null || object.getDocumentElement() == null ? null : (SchematronOutputType)new SVRLMarshaller().read((Node)object);
                    if (schematronOutputType != null) {
                        for (SVRLFailedAssert abstractSVRLMessage : SVRLHelper.getAllFailedAssertions(schematronOutputType)) {
                            ((ArrayList)object3).add(abstractSVRLMessage.getAsResourceError(iValidationSourceXML.getSystemID()));
                        }
                        for (SVRLSuccessfulReport sVRLSuccessfulReport : SVRLHelper.getAllSuccessfulReports(schematronOutputType)) {
                            ((ArrayList)object3).add(sVRLSuccessfulReport.getAsResourceError(iValidationSourceXML.getSystemID()));
                        }
                        break;
                    }
                    ((ArrayList)object3).add(((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builderError().setErrorLocation(new SimpleLocation(iReadableResource.getPath()))).setErrorText("Internal error interpreting Schematron result")).setErrorFieldName(object != null ? XMLWriter.getNodeAsString((Node)object) : null)).build());
                    break;
                }
                case OIOUBL: {
                    if (object != null && object.getDocumentElement() != null) {
                        for (Element element : XMLHelper.getChildElementIterator(object.getDocumentElement(), "Error")) {
                            String string = XMLHelper.getFirstChildElementOfName(element, "Pattern").getTextContent();
                            String string2 = XMLHelper.getFirstChildElementOfName(element, "Description").getTextContent();
                            String string3 = XMLHelper.getFirstChildElementOfName(element, "Xpath").getTextContent();
                            ((ArrayList)object3).add(((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)new SVRLResourceError.SVRLErrorBuilder(string).setErrorLocation(new SimpleLocation(iValidationSourceXML.getSystemID()))).setErrorText(string2)).setErrorFieldName(string3)).build());
                        }
                        break;
                    }
                    ((ArrayList)object3).add(((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builderError().setErrorLocation(new SimpleLocation(iReadableResource.getPath()))).setErrorText("Internal error - no Schematron output created for OIOUBL")).build());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported output type");
                }
            }
        }
        catch (Exception exception) {
            ((ArrayList)object3).add(((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builderError().setErrorLocation(new SimpleLocation(iReadableResource.getPath()))).setErrorText(exception.getMessage())).setLinkedException(exception)).build());
        }
        return new ValidationResult(iValidationArtefact, (IErrorList)object3);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ValidationExecutorSchematron validationExecutorSchematron = (ValidationExecutorSchematron)object;
        return this.m_bCacheSchematron == validationExecutorSchematron.m_bCacheSchematron && EqualsHelper.equals(this.m_sPrerequisiteXPath, validationExecutorSchematron.m_sPrerequisiteXPath) && EqualsHelper.equals(this.m_aNamespaceContext, validationExecutorSchematron.m_aNamespaceContext);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_bCacheSchematron).append(this.m_sPrerequisiteXPath).append(this.m_aNamespaceContext).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("CacheSchematron", this.m_bCacheSchematron).appendIfNotNull("PrerequisiteXPath", this.m_sPrerequisiteXPath).appendIfNotNull("NamespaceContext", this.m_aNamespaceContext).getToString();
    }

    private static enum ESchematronOutput {
        SVRL,
        OIOUBL;

    }
}

