/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.engine.schematron;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.xml.namespace.IIterableNamespaceContext;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SchematronNamespaceBeautifier {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final MapBasedNamespaceContext s_aCtx = new MapBasedNamespaceContext();

    private SchematronNamespaceBeautifier() {
    }

    public static void addMapping(@Nonnull String string, @Nonnull String string2) {
        s_aRWLock.writeLockedGet(() -> s_aCtx.setMapping(string, string2));
    }

    public static void addMappings(@Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        if (iIterableNamespaceContext != null) {
            s_aRWLock.writeLockedGet(() -> s_aCtx.setMappings(iIterableNamespaceContext));
        }
    }

    @Nonnull
    public static EChange removeAllMappings() {
        return s_aRWLock.writeLockedGet(s_aCtx::clear);
    }

    @Nullable
    public static String getMapping(@Nullable String string) {
        return s_aRWLock.readLockedGet(() -> s_aCtx.getPrefix(string));
    }
}

