/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.engine.mock;

import com.helger.bdve.api.executorset.VESID;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.io.resource.IReadableResource;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MockFile {
    private final IReadableResource m_aResource;
    private final VESID m_aVESID;
    private final ICommonsSet<String> m_aExpectedErrorIDs;

    public MockFile(@Nonnull IReadableResource iReadableResource, @Nonnull VESID vESID, @Nullable Set<String> set) {
        this.m_aResource = ValueEnforcer.notNull(iReadableResource, "Resource");
        this.m_aVESID = ValueEnforcer.notNull(vESID, "VESID");
        this.m_aExpectedErrorIDs = new CommonsHashSet<Set<String>>(set);
    }

    @Nonnull
    public IReadableResource getResource() {
        return this.m_aResource;
    }

    @Nonnull
    public VESID getVESID() {
        return this.m_aVESID;
    }

    public boolean isGoodCase() {
        return this.m_aExpectedErrorIDs.isEmpty();
    }

    public boolean isBadCase() {
        return this.m_aExpectedErrorIDs.isNotEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllExpectedErrorIDs() {
        return (ICommonsSet)this.m_aExpectedErrorIDs.getClone();
    }

    @Nonnull
    public static MockFile createGoodCase(@Nonnull IReadableResource iReadableResource, @Nonnull VESID vESID) {
        return new MockFile(iReadableResource, vESID, null);
    }
}

