/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.api.result;

import com.helger.bdve.api.artefact.IValidationArtefact;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.state.ETriState;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ValidationResult
implements ISuccessIndicator {
    private final IValidationArtefact m_aValidationArtefact;
    private final IErrorList m_aErrorList;
    private final ETriState m_eSuccess;

    public ValidationResult(@Nonnull IValidationArtefact iValidationArtefact, @Nonnull IErrorList iErrorList) {
        this(iValidationArtefact, iErrorList, ETriState.valueOf(iErrorList.containsNoError()));
    }

    protected ValidationResult(@Nonnull IValidationArtefact iValidationArtefact, @Nonnull IErrorList iErrorList, @Nonnull ETriState eTriState) {
        this.m_aValidationArtefact = ValueEnforcer.notNull(iValidationArtefact, "ValidationArtefact");
        this.m_aErrorList = ValueEnforcer.notNull(iErrorList, "ErrorList");
        this.m_eSuccess = ValueEnforcer.notNull(eTriState, "Success");
    }

    @Nonnull
    public IValidationArtefact getValidationArtefact() {
        return this.m_aValidationArtefact;
    }

    @Nonnull
    public IErrorList getErrorList() {
        return this.m_aErrorList;
    }

    @Override
    public boolean isSuccess() {
        return this.m_eSuccess.isTrue();
    }

    public boolean isIgnored() {
        return this.m_eSuccess.isUndefined();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ValidationArtefact", this.m_aValidationArtefact).append("ErrorList", this.m_aErrorList).append("Success", this.m_eSuccess).getToString();
    }

    @Nonnull
    public static ValidationResult createIgnoredResult(@Nonnull IValidationArtefact iValidationArtefact) {
        return new ValidationResult(iValidationArtefact, new ErrorList(), ETriState.UNDEFINED);
    }
}

