/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.api.executorset;

import com.helger.bdve.api.executorset.IValidationExecutorSet;
import com.helger.bdve.api.executorset.IValidationExecutorSetRegistry;
import com.helger.bdve.api.executorset.VESID;
import com.helger.bdve.api.executorset.ValidationExecutorSet;
import com.helger.bdve.api.source.IValidationSource;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ValidationExecutorSetRegistry<SOURCETYPE extends IValidationSource>
implements IValidationExecutorSetRegistry<SOURCETYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationExecutorSetRegistry.class);
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<VESID, IValidationExecutorSet<SOURCETYPE>> m_aMap = new CommonsHashMap<VESID, IValidationExecutorSet<SOURCETYPE>>();

    @Nonnull
    @MustBeLocked(value=ELockType.DEPENDS)
    protected final ICommonsMap<VESID, IValidationExecutorSet<SOURCETYPE>> internalMap() {
        return this.m_aMap;
    }

    @Override
    public void registerValidationExecutorSet(@Nonnull IValidationExecutorSet<SOURCETYPE> iValidationExecutorSet) {
        ValueEnforcer.notNull(iValidationExecutorSet, "VES");
        VESID vESID = (VESID)iValidationExecutorSet.getID();
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aMap.containsKey(vESID)) {
                throw new IllegalStateException("Another validation executor set with the ID '" + vESID.getAsSingleID() + "' is already registered!");
            }
            this.m_aMap.put(vESID, iValidationExecutorSet);
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registered validation executor set '" + vESID.getAsSingleID() + "' of type " + iValidationExecutorSet.getClass().getName() + " with " + iValidationExecutorSet.getCount() + " elements");
        }
    }

    @Override
    @Nonnull
    public EChange unregisterValidationExecutorSet(@Nullable VESID vESID) {
        if (vESID == null) {
            return EChange.UNCHANGED;
        }
        EChange eChange = this.m_aRWLock.writeLockedGet(() -> this.m_aMap.removeObject(vESID));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((eChange.isChanged() ? "Successfully unregistered" : "Failed to unregister") + " validation executor set '" + vESID.getAsSingleID() + "'");
        }
        return eChange;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IValidationExecutorSet<SOURCETYPE>> getAll() {
        return this.m_aRWLock.readLockedGet(this.m_aMap::copyOfValues);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IValidationExecutorSet<SOURCETYPE>> findAll(@Nonnull Predicate<? super IValidationExecutorSet<SOURCETYPE>> predicate) {
        return this.m_aRWLock.readLockedGet(() -> this.m_aMap.copyOfValues(predicate));
    }

    @Override
    @Nullable
    public IValidationExecutorSet<SOURCETYPE> findFirst(@Nonnull Predicate<? super IValidationExecutorSet<SOURCETYPE>> predicate) {
        return this.m_aRWLock.readLockedGet(() -> this.m_aMap.findFirstValue(entry -> predicate.test((Object)entry.getValue())));
    }

    @Override
    @Nullable
    public IValidationExecutorSet<SOURCETYPE> getOfID(@Nullable VESID vESID) {
        if (vESID == null) {
            return null;
        }
        return this.m_aRWLock.readLockedGet(() -> (IValidationExecutorSet)this.m_aMap.get(vESID));
    }

    @Nonnull
    public EChange removeAll() {
        return this.removeAll(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange removeAll(boolean bl) {
        EChange eChange = EChange.UNCHANGED;
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aMap.isNotEmpty()) {
                eChange = EChange.CHANGED;
                if (bl) {
                    for (IValidationExecutorSet iValidationExecutorSet : this.m_aMap.values()) {
                        if (!(iValidationExecutorSet instanceof ValidationExecutorSet)) continue;
                        ((ValidationExecutorSet)iValidationExecutorSet).removeAllExecutors();
                    }
                }
                this.m_aMap.clear();
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (eChange.isChanged() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully removed all validatione executor sets" + (bl ? " and cleaned all VES." : "."));
        }
        return eChange;
    }

    public String toString() {
        return new ToStringGenerator(this).append("Map", this.m_aMap).getToString();
    }
}

