/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.api.execute;

import com.helger.bdve.api.artefact.IValidationArtefact;
import com.helger.bdve.api.execute.IValidationExecutor;
import com.helger.bdve.api.source.IValidationSource;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AbstractValidationExecutor<SOURCETYPE extends IValidationSource, IMPLTYPE extends AbstractValidationExecutor<SOURCETYPE, IMPLTYPE>>
implements IValidationExecutor<SOURCETYPE>,
IGenericImplTrait<IMPLTYPE> {
    public static final boolean DEFAULT_STOP_VALIDATION_ON_ERROR = false;
    private final IValidationArtefact m_aValidationArtefact;
    private boolean m_bStopValidationOnError = false;

    public AbstractValidationExecutor(@Nonnull IValidationArtefact iValidationArtefact) {
        this.m_aValidationArtefact = ValueEnforcer.notNull(iValidationArtefact, "ValidationArtefact");
    }

    @Override
    @Nonnull
    public final IValidationArtefact getValidationArtefact() {
        return this.m_aValidationArtefact;
    }

    @Override
    public final boolean isStopValidationOnError() {
        return this.m_bStopValidationOnError;
    }

    @Nonnull
    public final IMPLTYPE setStopValidationOnError(boolean bl) {
        this.m_bStopValidationOnError = bl;
        return (IMPLTYPE)((AbstractValidationExecutor)this.thisAsT());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractValidationExecutor abstractValidationExecutor = (AbstractValidationExecutor)object;
        return this.m_aValidationArtefact.equals(abstractValidationExecutor.m_aValidationArtefact);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aValidationArtefact).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ValidationArtefact", this.m_aValidationArtefact).append("StopValidationOnError", this.m_bStopValidationOnError).getToString();
    }
}

