/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.api.artefact;

import com.helger.bdve.api.EValidationType;
import com.helger.bdve.api.artefact.IValidationArtefact;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ValidationArtefact
implements IValidationArtefact {
    private final EValidationType m_eValidationArtefactType;
    private final IReadableResource m_aResource;

    public ValidationArtefact(@Nonnull EValidationType eValidationType, @Nonnull IReadableResource iReadableResource) {
        this.m_eValidationArtefactType = ValueEnforcer.notNull(eValidationType, "ValidationArtefactType");
        this.m_aResource = ValueEnforcer.notNull(iReadableResource, "Resource");
    }

    @Override
    @Nonnull
    public EValidationType getValidationArtefactType() {
        return this.m_eValidationArtefactType;
    }

    @Override
    @Nonnull
    public IReadableResource getRuleResource() {
        return this.m_aResource;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ValidationArtefact validationArtefact = (ValidationArtefact)object;
        return this.m_eValidationArtefactType.equals(validationArtefact.m_eValidationArtefactType) && this.m_aResource.equals(validationArtefact.m_aResource);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eValidationArtefactType)).append(this.m_aResource).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ValidationArtefactType", this.m_eValidationArtefactType).append("Resource", this.m_aResource).getToString();
    }
}

