/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.view;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.accordion.Accordion;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import eu.toop.edm.EDMErrorResponse;
import eu.toop.edm.EDMResponse;
import eu.toop.playground.dc.ui.component.ConceptResponseComponent;
import eu.toop.playground.dc.ui.component.DataConsumerDetailsComponent;
import eu.toop.playground.dc.ui.component.DataProviderDetailsComponent;
import eu.toop.playground.dc.ui.component.DataSubjectComponent;
import eu.toop.playground.dc.ui.component.DocumentResponseComponent;
import eu.toop.playground.dc.ui.component.ErrorResponseComponent;
import eu.toop.playground.dc.ui.component.QueryDefinitionComponent;
import eu.toop.playground.dc.ui.component.RequestStatusGridComponent;
import eu.toop.playground.dc.ui.component.UploadComponent;
import eu.toop.playground.dc.ui.model.ConceptQueryFVBean;
import eu.toop.playground.dc.ui.model.ConceptResponseFVBean;
import eu.toop.playground.dc.ui.model.DocumentQueryFVBean;
import eu.toop.playground.dc.ui.model.DocumentResponseFVBean;
import eu.toop.playground.dc.ui.model.ErrorResponseFVBean;
import eu.toop.playground.dc.ui.model.LegalPersonFVBean;
import eu.toop.playground.dc.ui.model.NaturalPersonFVBean;
import eu.toop.playground.dc.ui.model.ResultBean;
import eu.toop.playground.dc.ui.presenter.MainPresenter;
import eu.toop.playground.dc.ui.service.BroadcasterService;
import eu.toop.playground.dc.ui.util.Utilities;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Route(value="")
@Push
@CssImport.Container(value={@CssImport(value="./styles/shared-styles.css"), @CssImport(value="./styles/vaadin-text-field-styles.css", themeFor="vaadin-text-field")})
public class DynamicRequestView
extends VerticalLayout
implements RouterLayout {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicRequestView.class);
    private MainPresenter presenter;
    Tab requestTab = new Tab("REQUEST");
    Tab responseTab = new Tab("RESPONSE");
    Div requestPage = new Div();
    Div responsePage = new Div();
    final Div header = new Div();
    final Div content = new Div();
    final Div queryContent = new Div();
    private DataConsumerDetailsComponent DCComponent;
    private DataSubjectComponent DSComponent;
    private QueryDefinitionComponent queryDefinitionComponent;
    private UploadComponent upload;
    private RequestStatusGridComponent requestStatusGridComponent;
    private DataProviderDetailsComponent dataProviderDetailsComponent;
    private ConceptResponseComponent conceptResponseComponent;
    private DocumentResponseComponent documentResponseComponent;
    private ErrorResponseComponent errorResponseComponent;
    private Registration broadcastRespRegistration;
    private Registration broadcastErrorRespRegistration;

    public DynamicRequestView() {
        this.setSizeFull();
        this.setPadding(false);
        this.setSpacing(false);
        this.setMargin(false);
        this.setDefaultHorizontalComponentAlignment(FlexComponent.Alignment.STRETCH);
        this.presenter = new MainPresenter();
        this.presenter.init(this);
        this.DSComponent = new DataSubjectComponent(this.presenter);
        this.header.getStyle().set("flexShrink", "0");
        this.header.setText("FREEDONIA | ONLINE");
        this.header.setClassName("header");
        this.header.setHeight("70px");
        this.content.setClassName("content");
        this.queryContent.setClassName("queryContent");
        this.add(new Component[]{this.header});
        H2 h2 = new H2("Data Subject Creation: ");
        H2 h22 = new H2("Query Definition: ");
        this.DCComponent = new DataConsumerDetailsComponent();
        this.requestPage.add(new Component[]{this.DCComponent, h2, this.content, h22, this.queryContent});
        this.requestPage.setSizeFull();
        this.responsePage.setSizeFull();
        this.responsePage.setClassName("responsePage");
        Tabs tabs = new Tabs(new Tab[]{this.requestTab, this.responseTab});
        tabs.setSelectedTab(this.requestTab);
        tabs.setFlexGrowForEnclosedTabs(1.0);
        this.add(new Component[]{tabs});
        this.add(new Component[]{this.requestPage});
        this.add(new Component[]{this.responsePage});
        this.requestPage.setVisible(true);
        this.responsePage.setVisible(false);
        tabs.addSelectedChangeListener((ComponentEventListener & Serializable)selectedChangeEvent -> {
            if (selectedChangeEvent.getSelectedTab() == this.requestTab) {
                this.requestPage.setVisible(true);
                this.responsePage.setVisible(false);
            } else {
                this.requestPage.setVisible(false);
                this.responsePage.setVisible(true);
            }
        });
        this.content.add(new Component[]{this.DSComponent});
        this.queryDefinitionComponent = new QueryDefinitionComponent(this.presenter, this.requestPage);
        this.queryContent.add(new Component[]{this.queryDefinitionComponent});
        this.requestStatusGridComponent = new RequestStatusGridComponent();
        this.responsePage.add(new Component[]{this.requestStatusGridComponent});
    }

    public void initStatusGrid(List<ResultBean> list) {
        this.requestStatusGridComponent.renderStatusGrid(list, this.presenter);
    }

    public void refreshStatusGrid() {
        this.requestStatusGridComponent.refreshGrid();
    }

    public void initNP(NaturalPersonFVBean naturalPersonFVBean) {
        this.DSComponent.renderNP(naturalPersonFVBean);
    }

    public void initLP(LegalPersonFVBean legalPersonFVBean) {
        this.DSComponent.renderLP(legalPersonFVBean);
    }

    public void initAR(NaturalPersonFVBean naturalPersonFVBean) {
        this.DSComponent.renderAR(naturalPersonFVBean);
    }

    public void initConceptQuery(ConceptQueryFVBean conceptQueryFVBean) {
        LOGGER.debug("Init concept query is called: ");
        this.queryDefinitionComponent.renderConceptQuery(conceptQueryFVBean);
    }

    public void initDocumentQuery(DocumentQueryFVBean documentQueryFVBean, String string) {
        LOGGER.debug("Init document query is called: ");
        this.queryDefinitionComponent.renderDocumentQuery(documentQueryFVBean, string);
    }

    public void renderConceptResponse(ConceptResponseFVBean conceptResponseFVBean) {
        LOGGER.debug("render concept response called: ");
        this.resetRenderedResponseComponents();
        this.dataProviderDetailsComponent = new DataProviderDetailsComponent(conceptResponseFVBean);
        this.conceptResponseComponent = new ConceptResponseComponent(conceptResponseFVBean);
        this.responsePage.add(new Component[]{this.dataProviderDetailsComponent, this.conceptResponseComponent});
    }

    public void renderDocumentResponse(DocumentResponseFVBean documentResponseFVBean) {
        this.resetRenderedResponseComponents();
        this.dataProviderDetailsComponent = new DataProviderDetailsComponent(documentResponseFVBean);
        this.documentResponseComponent = new DocumentResponseComponent(documentResponseFVBean, this.presenter);
        this.responsePage.add(new Component[]{this.dataProviderDetailsComponent, this.documentResponseComponent});
    }

    public void renderErrorResponse(ErrorResponseFVBean errorResponseFVBean) {
        this.resetRenderedResponseComponents();
        this.dataProviderDetailsComponent = new DataProviderDetailsComponent(errorResponseFVBean);
        this.errorResponseComponent = new ErrorResponseComponent(errorResponseFVBean);
        this.responsePage.add(new Component[]{this.dataProviderDetailsComponent, this.errorResponseComponent});
    }

    public void resetRenderedResponseComponents() {
        if (Utilities.dataProviderDetailsComponentExists(this.dataProviderDetailsComponent) && Utilities.documentResponseComponentExists(this.documentResponseComponent)) {
            this.responsePage.remove(new Component[]{this.dataProviderDetailsComponent});
            this.responsePage.remove(new Component[]{this.documentResponseComponent});
        }
        if (Utilities.dataProviderDetailsComponentExists(this.dataProviderDetailsComponent) && Utilities.conceptResponseComponentExists(this.conceptResponseComponent)) {
            this.responsePage.remove(new Component[]{this.dataProviderDetailsComponent});
            this.responsePage.remove(new Component[]{this.conceptResponseComponent});
        }
        if (Utilities.dataProviderDetailsComponentExists(this.dataProviderDetailsComponent) && Utilities.errorResponseComponentExists(this.errorResponseComponent)) {
            this.responsePage.remove(new Component[]{this.dataProviderDetailsComponent});
            this.responsePage.remove(new Component[]{this.errorResponseComponent});
        }
    }

    public Accordion resetAccordion() {
        return new Accordion();
    }

    protected void onAttach(AttachEvent attachEvent) {
        LOGGER.debug("On Attach Called");
        UI uI = attachEvent.getUI();
        this.broadcastRespRegistration = BroadcasterService.INSTANCE.registerResp(eDMResponse -> uI.access((Command & Serializable)() -> this.presenter.addResponse((EDMResponse)eDMResponse)));
        this.broadcastErrorRespRegistration = BroadcasterService.INSTANCE.registerErrorResp(eDMErrorResponse -> uI.access((Command & Serializable)() -> this.presenter.addErrorResponse((EDMErrorResponse)eDMErrorResponse)));
        super.onAttach(attachEvent);
    }

    protected void onDetach(DetachEvent detachEvent) {
        LOGGER.debug("On Detach Called");
        this.broadcastRespRegistration.remove();
        this.broadcastErrorRespRegistration.remove();
        this.broadcastRespRegistration = null;
        this.broadcastErrorRespRegistration = null;
    }
}

