/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.toop.playground.dc.config.enums.DCConfig;
import eu.toop.playground.dc.ui.model.dto.DSDDatasetResponseDto;
import eu.toop.playground.dc.ui.model.dto.DSDIDTypeDto;
import eu.toop.playground.dc.ui.model.dto.DSDResponseDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSDService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DSDService.class.getName());

    public List<DSDDatasetResponseDto> getDatasets(String string, String string2) throws IOException {
        return DCConfig.INSTANCE.useMockDSD() ? this.getMockDatasets(string) : this.getSimDatasets(string, string2).getDatasetDtoList();
    }

    public List<DSDDatasetResponseDto> getDatasets(String string) throws IOException {
        return DCConfig.INSTANCE.useMockDSD() ? this.getMockDatasets(string) : this.getSimDatasets(string).getDatasetDtoList();
    }

    DSDResponseDto getSimDatasets(String string) throws IOException {
        return this.getSimDatasets(string, null);
    }

    DSDResponseDto getSimDatasets(String string, @Nullable String string2) throws IOException {
        try (CloseableHttpClient closeableHttpClient = HttpClients.createDefault();){
            String string3 = Objects.isNull(string2) ? DCConfig.INSTANCE.getDSDEndpointURL() + "/" + string : DCConfig.INSTANCE.getDSDEndpointURL() + "/" + string + "/by-country/" + string2;
            HttpGet httpGet = new HttpGet(string3);
            httpGet.setHeader("Accept", "application/json");
            ResponseHandler responseHandler = httpResponse -> {
                int n = httpResponse.getStatusLine().getStatusCode();
                if (n == 200) {
                    HttpEntity httpEntity = httpResponse.getEntity();
                    if (httpEntity != null) {
                        LOGGER.debug("Entity is not null, parsing json...");
                        ObjectMapper objectMapper = new ObjectMapper();
                        DSDResponseDto dSDResponseDto = (DSDResponseDto)objectMapper.readerFor(DSDResponseDto.class).readValue(httpEntity.getContent());
                        return dSDResponseDto;
                    }
                    LOGGER.debug("The DSD Response has no Entity.");
                    throw new IOException("The DSD Response has no Entity.");
                }
                throw new ClientProtocolException("Unable to get requested datasets. Unexpected response status: " + n + " from " + DCConfig.INSTANCE.getDSDEndpointURL());
            };
            DSDResponseDto dSDResponseDto = (DSDResponseDto)closeableHttpClient.execute((HttpUriRequest)httpGet, responseHandler);
            return dSDResponseDto;
        }
    }

    private List<DSDDatasetResponseDto> getMockDatasets(String string) {
        DSDResponseDto dSDResponseDto = this.createSimpleDSDExample();
        DSDResponseDto dSDResponseDto2 = this.createSimpleDSDExample();
        ArrayList<DSDDatasetResponseDto> arrayList = new ArrayList<DSDDatasetResponseDto>();
        arrayList.addAll(dSDResponseDto.getDatasetDtoList());
        arrayList.addAll(dSDResponseDto2.getDatasetDtoList());
        return arrayList;
    }

    private List<DSDDatasetResponseDto> getConceptDataset(String string) {
        return this.getMockDatasets(string);
    }

    private DSDResponseDto createSimpleDSDExample() {
        DSDIDTypeDto dSDIDTypeDto = new DSDIDTypeDto("iso6523-actorid-upis", "9999:elonia");
        DSDIDTypeDto dSDIDTypeDto2 = new DSDIDTypeDto("toop-doctypeid-qns", "RegisteredOrganization::REGISTERED_ORGANIZATION_TYPE::CONCEPT##CCCEV::toop-edm:v2.0");
        DSDDatasetResponseDto dSDDatasetResponseDto = new DSDDatasetResponseDto(dSDIDTypeDto, "RegisteredOrganization", "CONCEPT", "CCCEV", "toop-edm:v2.0", dSDIDTypeDto2);
        ArrayList<DSDDatasetResponseDto> arrayList = new ArrayList<DSDDatasetResponseDto>();
        arrayList.add(dSDDatasetResponseDto);
        DSDResponseDto dSDResponseDto = new DSDResponseDto(true, arrayList, new Date(), 100L);
        return dSDResponseDto;
    }

    public DSDResponseDto createConceptDSDExample() {
        return this.createSimpleDSDExample();
    }
}

