/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.helger.commons.mime.CMimeType;
import eu.toop.connector.api.me.EMEProtocol;
import eu.toop.connector.api.rest.TCOutgoingMessage;
import eu.toop.connector.api.rest.TCOutgoingMetadata;
import eu.toop.connector.api.rest.TCPayload;
import eu.toop.connector.api.rest.TCRestJAXB;
import eu.toop.edm.EDMRequest;
import eu.toop.playground.dc.config.enums.DCConfig;
import eu.toop.playground.dc.ui.model.dto.DSDDatasetResponseDto;
import eu.toop.playground.dc.ui.model.dto.DSDIDTypeDto;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConnectionService.class.getName());

    public int submit(EDMRequest eDMRequest, DSDDatasetResponseDto dSDDatasetResponseDto) throws IOException {
        return DCConfig.INSTANCE.useDirectSubmit() ? this.submitDirect(eDMRequest) : this.submitThroughInfrastructure(eDMRequest, dSDDatasetResponseDto);
    }

    public int submit(EDMRequest eDMRequest) throws IOException {
        return DCConfig.INSTANCE.useDirectSubmit() ? this.submitDirect(eDMRequest) : this.submitThroughInfrastructure(eDMRequest);
    }

    private int submitDirect(EDMRequest eDMRequest) throws IOException {
        try (CloseableHttpClient closeableHttpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(DCConfig.INSTANCE.getSubmitRequestURL());
            httpPost.setHeader("Content-Type", "application/xml");
            httpPost.setEntity((HttpEntity)new InputStreamEntity((InputStream)eDMRequest.getWriter().getAsInputStream()));
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            int n = closeableHttpResponse.getStatusLine().getStatusCode();
            return n;
        }
    }

    private int submitThroughInfrastructure(EDMRequest eDMRequest) throws IOException {
        DSDDatasetResponseDto dSDDatasetResponseDto = new DSDDatasetResponseDto(new DSDIDTypeDto(DCConfig.INSTANCE.getDefaultEloniaDevParticipantIdScheme(), DCConfig.INSTANCE.getDefaultEloniaDevParticipantIdValue()), null, null, null, null, null);
        return this.submitThroughInfrastructure(eDMRequest, dSDDatasetResponseDto);
    }

    private int submitThroughInfrastructure(EDMRequest eDMRequest, DSDDatasetResponseDto dSDDatasetResponseDto) throws IOException {
        TCOutgoingMessage tCOutgoingMessage = new TCOutgoingMessage();
        TCOutgoingMetadata tCOutgoingMetadata = new TCOutgoingMetadata();
        tCOutgoingMetadata.setSenderID(TCRestJAXB.createTCID((String)DCConfig.INSTANCE.getDefaultEloniaDevSenderIdScheme(), (String)DCConfig.INSTANCE.getDefaultEloniaDevSenderIdValue()));
        tCOutgoingMetadata.setReceiverID(TCRestJAXB.createTCID((String)dSDDatasetResponseDto.getParticipantId().getScheme(), (String)dSDDatasetResponseDto.getParticipantId().getValue()));
        tCOutgoingMetadata.setDocTypeID(TCRestJAXB.createTCID((String)"toop-doctypeid-qns", (String)"RegisteredOrganization::REGISTERED_ORGANIZATION_TYPE::CONCEPT##CCCEV::toop-edm:v2.0"));
        tCOutgoingMetadata.setProcessID(TCRestJAXB.createTCID((String)"toop-procid-agreement", (String)"urn:eu.toop.process.dataquery"));
        tCOutgoingMetadata.setTransportProtocol(EMEProtocol.AS4.getTransportProfileID());
        tCOutgoingMessage.setMetadata(tCOutgoingMetadata);
        TCPayload tCPayload = new TCPayload();
        tCPayload.setValue(eDMRequest.getWriter().getAsBytes());
        tCPayload.setMimeType(CMimeType.APPLICATION_XML.getAsString());
        tCPayload.setContentID("mock-request@toop");
        tCOutgoingMessage.addPayload(tCPayload);
        try (CloseableHttpClient closeableHttpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(DCConfig.INSTANCE.getSubmitRequestURL());
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(TCRestJAXB.outgoingMessage().getAsBytes((Object)tCOutgoingMessage)));
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            this.evaluateDSDResponse(closeableHttpResponse.getEntity().getContent());
            int n = closeableHttpResponse.getStatusLine().getStatusCode();
            return n;
        }
    }

    private void evaluateDSDResponse(InputStream inputStream) throws IOException {
        LOGGER.debug("Evaluating DSD Response JSON...");
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(inputStream);
        boolean bl = jsonNode.get("validation-results").get("success").asBoolean();
        LOGGER.debug("The validation results success status is= {}", (Object)bl);
        if (!bl) {
            throw new IOException("The created TOOP Request failed to pass the validation...");
        }
        boolean bl2 = jsonNode.get("lookup-results").get("success").asBoolean();
        LOGGER.debug("The lookup results success status is= {}", (Object)bl2);
        if (!bl2) {
            throw new IOException("Unable to find the routing metadata...");
        }
        boolean bl3 = jsonNode.get("sending-results").get("success").asBoolean();
        LOGGER.debug("The sending result success status is= {}", (Object)bl3);
        if (!bl3) {
            throw new IOException("The created TOOP Request failed to send to DP...");
        }
    }
}

