/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.presenter;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.upload.receivers.MemoryBuffer;
import eu.toop.edm.EDMErrorResponse;
import eu.toop.edm.EDMRequest;
import eu.toop.edm.EDMResponse;
import eu.toop.edm.model.ConceptPojo;
import eu.toop.edm.model.DatasetPojo;
import eu.toop.edm.model.DistributionPojo;
import eu.toop.edm.model.EToopDistributionFormat;
import eu.toop.edm.request.EDMRequestPayloadConcepts;
import eu.toop.edm.request.EDMRequestPayloadDistribution;
import eu.toop.edm.response.EDMResponsePayloadConcepts;
import eu.toop.edm.response.IEDMResponsePayloadConcepts;
import eu.toop.edm.response.IEDMResponsePayloadDocument;
import eu.toop.edm.response.IEDMResponsePayloadDocumentReference;
import eu.toop.edm.response.IEDMResponsePayloadProvider;
import eu.toop.edm.response.ResponseDocumentPojo;
import eu.toop.edm.response.ResponseDocumentReferencePojo;
import eu.toop.playground.dc.config.enums.DCConfig;
import eu.toop.playground.dc.ui.component.ConceptQueryComponent;
import eu.toop.playground.dc.ui.component.DocumentQueryComponent;
import eu.toop.playground.dc.ui.component.DocumentResponseComponent;
import eu.toop.playground.dc.ui.component.RequestByIDButtonComponent;
import eu.toop.playground.dc.ui.model.AddressBean;
import eu.toop.playground.dc.ui.model.ConceptQueryFVBean;
import eu.toop.playground.dc.ui.model.ConceptResponseFVBean;
import eu.toop.playground.dc.ui.model.DocumentQueryFVBean;
import eu.toop.playground.dc.ui.model.DocumentResponseFVBean;
import eu.toop.playground.dc.ui.model.ErrorResponseFVBean;
import eu.toop.playground.dc.ui.model.LegalPersonFVBean;
import eu.toop.playground.dc.ui.model.NaturalPersonFVBean;
import eu.toop.playground.dc.ui.model.ResultBean;
import eu.toop.playground.dc.ui.model.dto.DSDDatasetResponseDto;
import eu.toop.playground.dc.ui.model.enums.EResponseStatus;
import eu.toop.playground.dc.ui.service.ConceptService;
import eu.toop.playground.dc.ui.service.ConnectionService;
import eu.toop.playground.dc.ui.service.DSDService;
import eu.toop.playground.dc.ui.util.MessageCreation;
import eu.toop.playground.dc.ui.util.Utilities;
import eu.toop.playground.dc.ui.view.DynamicRequestView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.client.ClientProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainPresenter {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MainPresenter.class.getName());
    private DynamicRequestView view;
    private NaturalPersonFVBean naturalPersonFVBean;
    private LegalPersonFVBean legalPersonFVBean;
    private NaturalPersonFVBean naturalPersonARFVBean;
    private ConceptQueryFVBean conceptQueryFVBean;
    private ConceptResponseFVBean conceptResponseFVBean;
    private DocumentResponseFVBean documentResponseFVBean;
    private DocumentQueryFVBean documentQueryFVBean;
    private ErrorResponseFVBean errorResponseFVBean;
    private List<DSDDatasetResponseDto> DSDDatasetResponseList;
    private List<ConceptPojo> allConcepts;
    private List<ResultBean> resultBeanList;
    private ConnectionService connectionService;
    private Map<String, ResultBean> resultMap;
    private final DSDService dsdService = new DSDService();
    private final ConceptService conceptService = new ConceptService();

    public void init(DynamicRequestView dynamicRequestView) {
        this.view = dynamicRequestView;
        LOGGER.debug("Got concept dataset from mock DSD: ");
        this.allConcepts = this.conceptService.getConceptPojoParent();
        this.conceptQueryFVBean = new ConceptQueryFVBean();
        this.documentQueryFVBean = new DocumentQueryFVBean();
        this.naturalPersonFVBean = new NaturalPersonFVBean();
        this.legalPersonFVBean = new LegalPersonFVBean();
        this.naturalPersonARFVBean = new NaturalPersonFVBean();
        this.conceptResponseFVBean = new ConceptResponseFVBean();
        this.documentResponseFVBean = new DocumentResponseFVBean();
        this.errorResponseFVBean = new ErrorResponseFVBean();
        this.resultBeanList = new ArrayList<ResultBean>();
        this.connectionService = new ConnectionService();
        this.resultMap = new LinkedHashMap<String, ResultBean>();
    }

    public void initDataSubject(HasValue.ValueChangeEvent valueChangeEvent) {
        LOGGER.debug("Radio button value: " + valueChangeEvent.getValue().toString());
        if (valueChangeEvent.getValue().toString().equals("Natural Person")) {
            this.naturalPersonFVBean = new NaturalPersonFVBean();
            this.view.initNP(this.naturalPersonFVBean);
        } else {
            this.legalPersonFVBean = new LegalPersonFVBean();
            this.view.initLP(this.legalPersonFVBean);
        }
    }

    public void initQueryType(HasValue.ValueChangeEvent valueChangeEvent) {
        LOGGER.debug("Radio button value: " + valueChangeEvent.getValue().toString());
        if (valueChangeEvent.getValue().toString().equals("Concept Query")) {
            this.view.initConceptQuery(this.conceptQueryFVBean);
        } else {
            this.view.initDocumentQuery(this.documentQueryFVBean, valueChangeEvent.getValue().toString());
        }
    }

    public void initAuthorizedRepresentative() {
        this.naturalPersonARFVBean = new NaturalPersonFVBean();
        this.view.initAR(this.naturalPersonARFVBean);
    }

    public void notifyDatasetIdentifierChange(HasValue.ValueChangeEvent valueChangeEvent) {
        LOGGER.info("Dataset identifier selected: " + valueChangeEvent.getValue().toString());
    }

    public void resetAuthorizedRepresentative() {
        this.naturalPersonARFVBean = new NaturalPersonFVBean();
    }

    public void resetNP() {
        this.naturalPersonFVBean = new NaturalPersonFVBean();
    }

    public void resetLP() {
        this.legalPersonFVBean = new LegalPersonFVBean();
    }

    public void notifyConceptSelection(Set<ConceptPojo> set) {
        this.conceptQueryFVBean.setConceptRequestList(set.stream().map(conceptPojo -> conceptPojo.getName()).collect(Collectors.toList()));
        LOGGER.debug("SELECTED CONCEPTS FROM UI: ");
        LOGGER.debug(Arrays.toString(this.conceptQueryFVBean.getConceptRequestList().toArray()));
    }

    public void populateConceptSelectionGrid(ConceptQueryComponent conceptQueryComponent) {
        conceptQueryComponent.renderConceptSelectionGrid(this.allConcepts);
    }

    public void populateDistributionGrid(DocumentQueryComponent documentQueryComponent, String string, String string2) throws IOException {
        documentQueryComponent.renderDatasetList(this.dsdService.getDatasets(string, string2));
    }

    public void populateConceptDatasetGrid(ConceptQueryComponent conceptQueryComponent, String string, String string2) throws IOException {
        conceptQueryComponent.renderConceptDatasetList(this.dsdService.getDatasets(string, string2));
    }

    public void showResponse(EDMResponse eDMResponse) {
        LOGGER.debug("INSIDE SHOW RESPONSE: ");
        LOGGER.debug("PAYLOAD PROVIDER SIZE: " + eDMResponse.getAllPayloadProviders().size());
        if (eDMResponse.getAllPayloadProviders().get(0) instanceof EDMResponsePayloadConcepts) {
            LOGGER.debug("INSIDE SHOW RESPONSE: CONCEPT: ");
            this.importConceptResponse(eDMResponse);
        } else if (eDMResponse.getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocument || eDMResponse.getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocumentReference) {
            LOGGER.debug("INSIDE SHOW RESPONSE: DOCUMENT: ");
            this.importDocumentResponse(eDMResponse);
        } else if (eDMResponse.getAllPayloadProviders().get(0) instanceof ResponseDocumentPojo || eDMResponse.getAllPayloadProviders().get(0) instanceof ResponseDocumentReferencePojo) {
            LOGGER.debug("INSIDE SHOW RESPONSE: DOCUMENT: ");
            this.importDocumentResponse(eDMResponse);
        }
    }

    public void showErrorResponse(EDMErrorResponse eDMErrorResponse) {
        LOGGER.debug("INSIDE SHOW ERROR RESPONSE: ");
        LOGGER.debug(eDMErrorResponse.getErrorProvider().toString());
        this.importErrorResponse(eDMErrorResponse);
    }

    public void createConceptRequestMessage(ConceptQueryComponent conceptQueryComponent, DSDDatasetResponseDto dSDDatasetResponseDto) {
        LOGGER.debug("Create ConceptQuery Request message ....");
        this.makeConceptRequests(conceptQueryComponent, dSDDatasetResponseDto);
    }

    public void makeConceptRequests(ConceptQueryComponent conceptQueryComponent, DSDDatasetResponseDto dSDDatasetResponseDto) {
        EDMRequest.BuilderConcept builderConcept = EDMRequest.builderConcept();
        this.addCommonSlots(builderConcept);
        this.addConcepts(builderConcept);
        EDMRequest eDMRequest = ((EDMRequest.BuilderConcept)builderConcept.randomID()).build();
        this.submitRequest(eDMRequest, dSDDatasetResponseDto);
        conceptQueryComponent.downloadXML(eDMRequest);
    }

    public void addConcepts(EDMRequest.BuilderConcept builderConcept) {
        builderConcept.concept(MessageCreation.createConceptRequestListFromQName(this.conceptQueryFVBean.getConceptRequestList()));
    }

    public void addCommonSlots(EDMRequest.BuilderConcept builderConcept) {
        ((EDMRequest.BuilderConcept)((EDMRequest.BuilderConcept)((EDMRequest.BuilderConcept)((EDMRequest.BuilderConcept)((EDMRequest.BuilderConcept)builderConcept.issueDateTimeNow()).procedure(Locale.US, this.conceptQueryFVBean.getProcedure())).dataConsumer(MessageCreation.createDataConsumer())).datasetIdentifier(this.conceptQueryFVBean.getDatasetIdentifier())).specificationIdentifier(this.conceptQueryFVBean.getSpecificationIdentifier())).consentToken(this.conceptQueryFVBean.getConsentToken());
        this.addDataSubject(builderConcept);
    }

    public void addDataSubject(EDMRequest.BuilderConcept builderConcept) {
        if (Utilities.authorizedRepresentativeExistsAndNotEmpty(this.naturalPersonARFVBean)) {
            LOGGER.debug("INSIDE AUTHORIZED REPRESENTATIVE");
            builderConcept.authorizedRepresentative(MessageCreation.createNaturalPerson(this.naturalPersonARFVBean, this.naturalPersonARFVBean.getAddress()));
        }
        if (Utilities.legalPersonExistsAndNotEmpty(this.legalPersonFVBean)) {
            LOGGER.debug("INSIDE LEGAL PERSON EXIST: ");
            builderConcept.dataSubject(MessageCreation.createLegalPerson(this.legalPersonFVBean, this.legalPersonFVBean.getAddress()));
        }
        if (Utilities.naturalPersonExistsAndNotEmpty(this.naturalPersonFVBean)) {
            LOGGER.debug("INSIDE NATURAL PERSON BEAN");
            builderConcept.dataSubject(MessageCreation.createNaturalPerson(this.naturalPersonFVBean, this.naturalPersonFVBean.getAddress()));
        }
    }

    private void submitRequest(EDMRequest eDMRequest, DSDDatasetResponseDto dSDDatasetResponseDto) {
        try {
            int n = this.connectionService.submit(eDMRequest, dSDDatasetResponseDto);
            LOGGER.debug("Inside submit request: STATUS={}", (Object)n);
            if (n != 204 && n != 200) {
                LOGGER.error("Request with id: {} didn't added in map. Request submission failed.", (Object)eDMRequest.getRequestID());
                throw new ClientProtocolException("Unable to send request to the connector. Unexpected response status: " + n + " from: " + DCConfig.INSTANCE.getSubmitRequestURL());
            }
            this.resultMap.put(eDMRequest.getRequestID(), new ResultBean(eDMRequest, dSDDatasetResponseDto));
            LOGGER.debug("Request with id: {} added in map. Request submitted successfully.", (Object)eDMRequest.getRequestID());
            this.resultBeanList = this.resultMap.entrySet().stream().map(entry -> (ResultBean)entry.getValue()).collect(Collectors.toList());
            this.view.initStatusGrid(this.resultBeanList);
        }
        catch (IOException iOException) {
            Notification notification = new Notification("Unable to send request to the connector", 5000, Notification.Position.TOP_START);
            notification.addThemeVariants(new NotificationVariant[]{NotificationVariant.LUMO_PRIMARY, NotificationVariant.LUMO_ERROR});
            notification.open();
            Notification notification2 = new Notification(iOException.getMessage(), 5000, Notification.Position.TOP_START);
            notification2.addThemeVariants(new NotificationVariant[]{NotificationVariant.LUMO_PRIMARY, NotificationVariant.LUMO_ERROR});
            notification2.open();
            LOGGER.error(iOException.getMessage());
        }
    }

    public void addResponse(EDMResponse eDMResponse) {
        LOGGER.info("EDMResponse received {}", (Object)eDMResponse.getRequestID());
        if (this.resultMap.keySet().contains(eDMResponse.getRequestID())) {
            this.resultMap.get(eDMResponse.getRequestID()).setStatus(EResponseStatus.SUCCESS);
            this.resultMap.get(eDMResponse.getRequestID()).setResponse(eDMResponse);
            this.resultBeanList = this.resultMap.entrySet().stream().map(entry -> (ResultBean)entry.getValue()).collect(Collectors.toList());
            this.view.refreshStatusGrid();
            LOGGER.debug("Result Bean List has been created successfully");
        } else {
            LOGGER.debug("EDMResponse {} is NOT mine", (Object)eDMResponse.getRequestID());
        }
    }

    public void addErrorResponse(EDMErrorResponse eDMErrorResponse) {
        LOGGER.debug("EDMErrorResponse received {}", (Object)eDMErrorResponse.getRequestID());
        if (this.resultMap.keySet().contains(eDMErrorResponse.getRequestID())) {
            this.resultMap.get(eDMErrorResponse.getRequestID()).setStatus(EResponseStatus.FAILED);
            this.resultMap.get(eDMErrorResponse.getRequestID()).setErrorResponse(eDMErrorResponse);
            this.resultBeanList = this.resultMap.entrySet().stream().map(entry -> (ResultBean)entry.getValue()).collect(Collectors.toList());
            this.view.refreshStatusGrid();
            LOGGER.debug("Result Bean List has been created successfully");
        } else {
            LOGGER.debug("EDMResponse {} is NOT mine", (Object)eDMErrorResponse.getRequestID());
        }
    }

    public void createDocumentRefIDRequestMessage(DocumentResponseComponent documentResponseComponent, String string, RequestByIDButtonComponent requestByIDButtonComponent) {
        LOGGER.debug("CREATE DOCUMENT ID REQUEST MESSAGE...");
        EDMRequest eDMRequest = this.resultMap.get(documentResponseComponent.getDocumentResponseFVBean().getRequestID()).getRequest();
        this.resetBeans();
        this.resetValuesDocumentQuery(eDMRequest);
        this.resetValuesDataSubject(eDMRequest);
        LOGGER.debug("Resend document query message: ");
        EDMRequest.BuilderDocumentByID builderDocumentByID = EDMRequest.builderDocumentByID();
        this.addCommonSlots(builderDocumentByID);
        this.addDataSubject(builderDocumentByID);
        if (documentResponseComponent.getDocumentResponseFVBean().getResponse().getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocumentReference) {
            this.addDocumentID(builderDocumentByID, string);
        }
        eDMRequest = ((EDMRequest.BuilderDocumentByID)builderDocumentByID.randomID()).build();
        this.submitRequest(eDMRequest, this.resultMap.get(documentResponseComponent.getDocumentResponseFVBean().getRequestID()).getDsdDTO());
        LOGGER.debug(eDMRequest.getWriter().getAsString());
        requestByIDButtonComponent.setRequest(eDMRequest);
    }

    public void createDocumentRefRequestMessage(DocumentQueryComponent documentQueryComponent, DSDDatasetResponseDto dSDDatasetResponseDto) {
        LOGGER.debug("CREATE DOCUMENT REFERENCE REQUEST MESSAGE...");
        EDMRequest.BuilderDocumentsByDistribution builderDocumentsByDistribution = EDMRequest.builderDocumentReferencesByDistribution();
        this.addCommonSlots(builderDocumentsByDistribution);
        this.addDistribution(builderDocumentsByDistribution);
        EDMRequest eDMRequest = ((EDMRequest.BuilderDocumentsByDistribution)builderDocumentsByDistribution.randomID()).build();
        this.submitRequest(eDMRequest, dSDDatasetResponseDto);
        documentQueryComponent.downloadXML(eDMRequest);
    }

    public void createDocumentRequestMessage(DocumentQueryComponent documentQueryComponent, DSDDatasetResponseDto dSDDatasetResponseDto) {
        LOGGER.debug("CREATE DOCUMENT REQUEST MESSAGE...");
        EDMRequest.BuilderDocumentsByDistribution builderDocumentsByDistribution = EDMRequest.builderDocumentsByDistribution();
        this.addCommonSlots(builderDocumentsByDistribution);
        this.addDistribution(builderDocumentsByDistribution);
        EDMRequest eDMRequest = ((EDMRequest.BuilderDocumentsByDistribution)builderDocumentsByDistribution.randomID()).build();
        this.submitRequest(eDMRequest, dSDDatasetResponseDto);
        documentQueryComponent.downloadXML(eDMRequest);
    }

    public void addDistribution(EDMRequest.BuilderDocumentsByDistribution builderDocumentsByDistribution) {
        builderDocumentsByDistribution.addDistribution(DistributionPojo.builder().format(EToopDistributionFormat.valueOf((String)"UNSTRUCTURED")).mediaType("application/pdf").build());
    }

    public void addDocumentID(EDMRequest.BuilderDocumentByID builderDocumentByID, String string) {
        builderDocumentByID.documentID(string);
    }

    public void addCommonSlots(EDMRequest.BuilderDocumentsByDistribution builderDocumentsByDistribution) {
        ((EDMRequest.BuilderDocumentsByDistribution)((EDMRequest.BuilderDocumentsByDistribution)((EDMRequest.BuilderDocumentsByDistribution)((EDMRequest.BuilderDocumentsByDistribution)((EDMRequest.BuilderDocumentsByDistribution)builderDocumentsByDistribution.issueDateTimeNow()).procedure(Locale.US, this.documentQueryFVBean.getProcedure())).dataConsumer(MessageCreation.createDataConsumer())).datasetIdentifier(this.documentQueryFVBean.getDatasetIdentifier())).specificationIdentifier(this.documentQueryFVBean.getSpecificationIdentifier())).consentToken(this.documentQueryFVBean.getConsentToken());
        this.addDataSubject(builderDocumentsByDistribution);
    }

    public void addCommonSlots(EDMRequest.BuilderDocumentByID builderDocumentByID) {
        ((EDMRequest.BuilderDocumentByID)((EDMRequest.BuilderDocumentByID)((EDMRequest.BuilderDocumentByID)((EDMRequest.BuilderDocumentByID)((EDMRequest.BuilderDocumentByID)builderDocumentByID.issueDateTimeNow()).procedure(Locale.US, this.documentQueryFVBean.getProcedure())).dataConsumer(MessageCreation.createDataConsumer())).datasetIdentifier(this.documentQueryFVBean.getDatasetIdentifier())).specificationIdentifier(this.documentQueryFVBean.getSpecificationIdentifier())).consentToken(this.documentQueryFVBean.getConsentToken());
        this.addDataSubject(builderDocumentByID);
    }

    public void addDataSubject(EDMRequest.BuilderDocumentsByDistribution builderDocumentsByDistribution) {
        if (Utilities.authorizedRepresentativeExistsAndNotEmpty(this.naturalPersonARFVBean)) {
            LOGGER.debug("INSIDE AUTHORIZED REPRESENTATIVE");
            builderDocumentsByDistribution.authorizedRepresentative(MessageCreation.createNaturalPerson(this.naturalPersonARFVBean, this.naturalPersonARFVBean.getAddress()));
        }
        if (Utilities.legalPersonExistsAndNotEmpty(this.legalPersonFVBean)) {
            LOGGER.debug("INSIDE LEGAL PERSON EXIST: ");
            builderDocumentsByDistribution.dataSubject(MessageCreation.createLegalPerson(this.legalPersonFVBean, this.legalPersonFVBean.getAddress()));
        }
        if (Utilities.naturalPersonExistsAndNotEmpty(this.naturalPersonFVBean)) {
            LOGGER.debug("INSIDE NATURAL PERSON BEAN");
            builderDocumentsByDistribution.dataSubject(MessageCreation.createNaturalPerson(this.naturalPersonFVBean, this.naturalPersonFVBean.getAddress()));
        }
    }

    public void addDataSubject(EDMRequest.BuilderDocumentByID builderDocumentByID) {
        if (Utilities.authorizedRepresentativeExistsAndNotEmpty(this.naturalPersonARFVBean)) {
            LOGGER.debug("INSIDE AUTHORIZED REPRESENTATIVE");
            builderDocumentByID.authorizedRepresentative(MessageCreation.createNaturalPerson(this.naturalPersonARFVBean, this.naturalPersonARFVBean.getAddress()));
        }
        if (Utilities.legalPersonExistsAndNotEmpty(this.legalPersonFVBean)) {
            LOGGER.debug("INSIDE LEGAL PERSON EXIST: ");
            builderDocumentByID.dataSubject(MessageCreation.createLegalPerson(this.legalPersonFVBean, this.legalPersonFVBean.getAddress()));
        }
        if (Utilities.naturalPersonExistsAndNotEmpty(this.naturalPersonFVBean)) {
            LOGGER.debug("INSIDE NATURAL PERSON BEAN");
            builderDocumentByID.dataSubject(MessageCreation.createNaturalPerson(this.naturalPersonFVBean, this.naturalPersonFVBean.getAddress()));
        }
    }

    public void resendConceptQuery(EDMRequest eDMRequest, DSDDatasetResponseDto dSDDatasetResponseDto) {
        this.resetBeans();
        this.resetValuesConceptQuery(eDMRequest);
        this.resetValuesDataSubject(eDMRequest);
        LOGGER.debug("Resend concept query message: ");
        EDMRequest.BuilderConcept builderConcept = EDMRequest.builderConcept();
        this.addCommonSlots(builderConcept);
        this.addConcepts(builderConcept);
        this.addDataSubject(builderConcept);
        eDMRequest = ((EDMRequest.BuilderConcept)builderConcept.randomID()).build();
        this.submitRequest(eDMRequest, dSDDatasetResponseDto);
    }

    public void resetValuesDataSubject(EDMRequest eDMRequest) {
        AddressBean addressBean;
        if (Utilities.personPojoExists(eDMRequest.getAuthorizedRepresentative())) {
            this.naturalPersonARFVBean.setPersonID(eDMRequest.getAuthorizedRepresentative().getID());
            this.naturalPersonARFVBean.setPersonFamilyName(eDMRequest.getAuthorizedRepresentative().getFamilyName());
            this.naturalPersonARFVBean.setPersonGivenName(eDMRequest.getAuthorizedRepresentative().getGivenName());
            this.naturalPersonARFVBean.setPersonGenderCode(eDMRequest.getAuthorizedRepresentative().getGenderCode());
            this.naturalPersonARFVBean.setPersonBirthName(eDMRequest.getAuthorizedRepresentative().getBirthName());
            this.naturalPersonARFVBean.setPersonBirthDate(eDMRequest.getAuthorizedRepresentative().getBirthDate());
            this.naturalPersonARFVBean.setPersonPlaceOfBirthAddressPostName(eDMRequest.getAuthorizedRepresentative().getBirthTown());
            addressBean = new AddressBean();
            assert (eDMRequest.getAuthorizedRepresentative().getAddress() != null);
            addressBean.setAddressFullAddress(eDMRequest.getAuthorizedRepresentative().getAddress().getFullAddress());
            addressBean.setAddressLocatorDesignator(eDMRequest.getAuthorizedRepresentative().getAddress().getStreetName());
            addressBean.setAddressThoroughfare(eDMRequest.getAuthorizedRepresentative().getAddress().getBuildingNumber());
            addressBean.setAddressPostName(eDMRequest.getAuthorizedRepresentative().getAddress().getTown());
            addressBean.setAddressAdminUnitFirstline(eDMRequest.getAuthorizedRepresentative().getAddress().getCountryCode());
            addressBean.setAddressPostCode(eDMRequest.getAuthorizedRepresentative().getAddress().getPostalCode());
            this.naturalPersonARFVBean.setAddress(addressBean);
        }
        if (Utilities.personPojoExists(eDMRequest.getDataSubjectNaturalPerson())) {
            this.naturalPersonFVBean.setPersonID(eDMRequest.getDataSubjectNaturalPerson().getID());
            this.naturalPersonFVBean.setPersonFamilyName(eDMRequest.getDataSubjectNaturalPerson().getFamilyName());
            this.naturalPersonFVBean.setPersonGivenName(eDMRequest.getDataSubjectNaturalPerson().getGivenName());
            this.naturalPersonFVBean.setPersonGenderCode(eDMRequest.getDataSubjectNaturalPerson().getGenderCode());
            this.naturalPersonFVBean.setPersonBirthName(eDMRequest.getDataSubjectNaturalPerson().getBirthName());
            this.naturalPersonFVBean.setPersonBirthDate(eDMRequest.getDataSubjectNaturalPerson().getBirthDate());
            this.naturalPersonFVBean.setPersonPlaceOfBirthAddressPostName(eDMRequest.getDataSubjectNaturalPerson().getBirthTown());
            addressBean = new AddressBean();
            assert (eDMRequest.getDataSubjectNaturalPerson().getAddress() != null);
            addressBean.setAddressFullAddress(eDMRequest.getDataSubjectNaturalPerson().getAddress().getFullAddress());
            addressBean.setAddressLocatorDesignator(eDMRequest.getDataSubjectNaturalPerson().getAddress().getStreetName());
            addressBean.setAddressThoroughfare(eDMRequest.getDataSubjectNaturalPerson().getAddress().getBuildingNumber());
            addressBean.setAddressPostName(eDMRequest.getDataSubjectNaturalPerson().getAddress().getTown());
            addressBean.setAddressAdminUnitFirstline(eDMRequest.getDataSubjectNaturalPerson().getAddress().getCountryCode());
            addressBean.setAddressPostCode(eDMRequest.getDataSubjectNaturalPerson().getAddress().getPostalCode());
            this.naturalPersonFVBean.setAddress(addressBean);
        }
        if (Utilities.businessPojoExists(eDMRequest.getDataSubjectLegalPerson())) {
            this.legalPersonFVBean.setLegalEntityID(eDMRequest.getDataSubjectLegalPerson().getLegalID());
            this.legalPersonFVBean.setLegalEntityLegalID(eDMRequest.getDataSubjectLegalPerson().getLegalIDSchemeID());
            this.legalPersonFVBean.setLegalEntityName(eDMRequest.getDataSubjectLegalPerson().getLegalName());
            addressBean = new AddressBean();
            assert (eDMRequest.getDataSubjectLegalPerson().getAddress() != null);
            addressBean.setAddressFullAddress(eDMRequest.getDataSubjectLegalPerson().getAddress().getFullAddress());
            addressBean.setAddressLocatorDesignator(eDMRequest.getDataSubjectLegalPerson().getAddress().getStreetName());
            addressBean.setAddressThoroughfare(eDMRequest.getDataSubjectLegalPerson().getAddress().getBuildingNumber());
            addressBean.setAddressPostName(eDMRequest.getDataSubjectLegalPerson().getAddress().getTown());
            addressBean.setAddressAdminUnitFirstline(eDMRequest.getDataSubjectLegalPerson().getAddress().getCountryCode());
            addressBean.setAddressPostCode(eDMRequest.getDataSubjectLegalPerson().getAddress().getPostalCode());
            this.legalPersonFVBean.setAddress(addressBean);
        }
    }

    public void resetValuesConceptQuery(EDMRequest eDMRequest) {
        this.conceptQueryFVBean.setProcedure(eDMRequest.getProcedure().toString());
        this.conceptQueryFVBean.setDatasetIdentifier(eDMRequest.getDatasetIdentifier());
        this.conceptQueryFVBean.setSpecificationIdentifier(eDMRequest.getSpecificationIdentifier());
        this.conceptQueryFVBean.setConsentToken(eDMRequest.getConsentToken());
        EDMRequestPayloadConcepts eDMRequestPayloadConcepts = (EDMRequestPayloadConcepts)eDMRequest.getPayloadProvider();
        this.conceptQueryFVBean.setConceptRequestList(((ConceptPojo)eDMRequestPayloadConcepts.getAllConcepts().get(0)).getAllChildren().stream().map(conceptPojo -> conceptPojo.getName()).collect(Collectors.toList()));
    }

    public void resendDocumentQuery(EDMRequest eDMRequest, DSDDatasetResponseDto dSDDatasetResponseDto) {
        this.resetBeans();
        this.resetValuesDocumentQuery(eDMRequest);
        this.resetValuesDataSubject(eDMRequest);
        LOGGER.debug("Resend document query message: ");
        EDMRequest.BuilderDocumentsByDistribution builderDocumentsByDistribution = EDMRequest.builderDocumentsByDistribution();
        this.addCommonSlots(builderDocumentsByDistribution);
        this.addDataSubject(builderDocumentsByDistribution);
        this.addDistribution(builderDocumentsByDistribution);
        eDMRequest = ((EDMRequest.BuilderDocumentsByDistribution)builderDocumentsByDistribution.randomID()).build();
        this.submitRequest(eDMRequest, dSDDatasetResponseDto);
    }

    public void resetValuesDocumentQuery(EDMRequest eDMRequest) {
        this.documentQueryFVBean.setProcedure(eDMRequest.getProcedure().toString());
        this.documentQueryFVBean.setDatasetIdentifier(eDMRequest.getDatasetIdentifier());
        this.documentQueryFVBean.setSpecificationIdentifier(eDMRequest.getSpecificationIdentifier());
        this.documentQueryFVBean.setConsentToken(eDMRequest.getConsentToken());
        EDMRequestPayloadDistribution eDMRequestPayloadDistribution = (EDMRequestPayloadDistribution)eDMRequest.getPayloadProvider();
        this.documentQueryFVBean.setDistributionList(eDMRequestPayloadDistribution.getAllDistributions());
    }

    public void resetBeans() {
        this.conceptQueryFVBean = new ConceptQueryFVBean();
        this.documentQueryFVBean = new DocumentQueryFVBean();
        this.naturalPersonFVBean = new NaturalPersonFVBean();
        this.legalPersonFVBean = new LegalPersonFVBean();
        this.naturalPersonARFVBean = new NaturalPersonFVBean();
    }

    public void importResponseFromUpload(MemoryBuffer memoryBuffer) {
        EDMResponse eDMResponse = (EDMResponse)EDMResponse.reader().read(memoryBuffer.getInputStream());
        this.conceptResponseFVBean.setRequestID(eDMResponse.getRequestID());
        this.conceptResponseFVBean.setDataProviderID(eDMResponse.getDataProvider().getID());
        this.conceptResponseFVBean.setDataProviderName(eDMResponse.getDataProvider().getName());
        if (eDMResponse.getAllPayloadProviders().get(0) instanceof EDMResponsePayloadConcepts) {
            EDMResponsePayloadConcepts eDMResponsePayloadConcepts = (EDMResponsePayloadConcepts)eDMResponse.getAllPayloadProviders().get(0);
            this.conceptResponseFVBean.setAllConcepts(eDMResponsePayloadConcepts.getAllConcepts());
            this.conceptResponseFVBean.setRootConcept((ConceptPojo)eDMResponsePayloadConcepts.getAllConcepts().get(0));
            this.conceptResponseFVBean.setConcepts(((ConceptPojo)eDMResponsePayloadConcepts.concepts().get(0)).getAllChildren());
        }
        LOGGER.debug("PARENT CONCEPT: " + this.conceptResponseFVBean.getAllConcepts().get(0).getID());
        this.view.renderConceptResponse(this.conceptResponseFVBean);
    }

    public void importDocumentResponse(EDMResponse eDMResponse) {
        ArrayList<DatasetPojo> arrayList;
        this.documentResponseFVBean.setResponse(eDMResponse);
        this.documentResponseFVBean.setRequestID(eDMResponse.getRequestID());
        this.documentResponseFVBean.setDataProviderID(eDMResponse.getDataProvider().getID());
        this.documentResponseFVBean.setDataProviderName(eDMResponse.getDataProvider().getName());
        LOGGER.debug("PAYLOAD PROVIDER SIZE: " + eDMResponse.getAllPayloadProviders().size());
        if (eDMResponse.getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocumentReference) {
            arrayList = new ArrayList<DatasetPojo>();
            for (IEDMResponsePayloadProvider iEDMResponsePayloadProvider : eDMResponse.getAllPayloadProviders()) {
                arrayList.add(((IEDMResponsePayloadDocumentReference)iEDMResponsePayloadProvider).getDataset());
                this.documentResponseFVBean.setDatasetList(arrayList);
            }
            IEDMResponsePayloadDocumentReference iEDMResponsePayloadDocumentReference = (IEDMResponsePayloadDocumentReference)eDMResponse.getAllPayloadProviders().get(0);
            this.documentResponseFVBean.setDataset(iEDMResponsePayloadDocumentReference.getDataset());
        }
        if (eDMResponse.getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocument) {
            arrayList = new ArrayList();
            for (IEDMResponsePayloadProvider iEDMResponsePayloadProvider : eDMResponse.getAllPayloadProviders()) {
                arrayList.add(((IEDMResponsePayloadDocument)iEDMResponsePayloadProvider).getDataset());
                LOGGER.debug("DatasetList is " + arrayList);
                this.documentResponseFVBean.setDatasetList(arrayList);
            }
        }
        LOGGER.debug("Import Document Response NOT YET READY. ");
        this.view.renderDocumentResponse(this.documentResponseFVBean);
    }

    public void importConceptResponse(EDMResponse eDMResponse) {
        LOGGER.debug("INSIDE importConceptResponse: ");
        this.conceptResponseFVBean.setRequestID(eDMResponse.getRequestID());
        this.conceptResponseFVBean.setDataProviderID(eDMResponse.getDataProvider().getID());
        this.conceptResponseFVBean.setDataProviderName(eDMResponse.getDataProvider().getName());
        if (eDMResponse.getAllPayloadProviders().get(0) instanceof EDMResponsePayloadConcepts) {
            IEDMResponsePayloadConcepts iEDMResponsePayloadConcepts = (IEDMResponsePayloadConcepts)eDMResponse.getAllPayloadProviders().get(0);
            this.conceptResponseFVBean.setAllConcepts(iEDMResponsePayloadConcepts.getAllConcepts());
            this.conceptResponseFVBean.setRootConcept((ConceptPojo)iEDMResponsePayloadConcepts.getAllConcepts().get(0));
            this.conceptResponseFVBean.setConcepts(((ConceptPojo)iEDMResponsePayloadConcepts.concepts().get(0)).getAllChildren());
        }
        this.view.renderConceptResponse(this.conceptResponseFVBean);
    }

    public void importErrorResponse(EDMErrorResponse eDMErrorResponse) {
        LOGGER.debug("INSIDE importErrorResponse: ");
        this.errorResponseFVBean.setErrorProviderID(eDMErrorResponse.getErrorProvider().getID());
        this.errorResponseFVBean.setErrorProviderName(eDMErrorResponse.getErrorProvider().getName());
        this.errorResponseFVBean.setRequestID(eDMErrorResponse.getRequestID());
        this.errorResponseFVBean.setResponseStatus(eDMErrorResponse.getResponseStatus().toString());
        this.errorResponseFVBean.setExceptionList(eDMErrorResponse.getAllExceptions());
        this.view.renderErrorResponse(this.errorResponseFVBean);
    }
}

