/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.model;

import eu.toop.edm.EDMErrorResponse;
import eu.toop.edm.EDMRequest;
import eu.toop.edm.EDMResponse;
import eu.toop.playground.dc.ui.model.dto.DSDDatasetResponseDto;
import eu.toop.playground.dc.ui.model.enums.EResponseStatus;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public class ResultBean {
    private EDMRequest request;
    private EDMResponse response;
    private EDMErrorResponse errorResponse;
    private EResponseStatus status;
    private String dpIdentifier;
    private DSDDatasetResponseDto dsdDTO;

    public DSDDatasetResponseDto getDsdDTO() {
        return this.dsdDTO;
    }

    public void setDsdDTO(DSDDatasetResponseDto dSDDatasetResponseDto) {
        this.dsdDTO = dSDDatasetResponseDto;
    }

    public ResultBean(@NotNull EDMRequest eDMRequest) {
        this.request = eDMRequest;
        this.status = EResponseStatus.PENDING;
    }

    public ResultBean(@NotNull EDMRequest eDMRequest, @NotNull DSDDatasetResponseDto dSDDatasetResponseDto) {
        this.request = eDMRequest;
        this.status = EResponseStatus.PENDING;
        this.dpIdentifier = dSDDatasetResponseDto.getParticipantId().getValue();
        this.dsdDTO = dSDDatasetResponseDto;
    }

    public String getDpIdentifier() {
        return this.dpIdentifier;
    }

    public void setDpIdentifier(String string) {
        this.dpIdentifier = string;
    }

    public EDMRequest getRequest() {
        return this.request;
    }

    public void setRequest(EDMRequest eDMRequest) {
        this.request = eDMRequest;
    }

    public EDMResponse getResponse() {
        return this.response;
    }

    public void setResponse(EDMResponse eDMResponse) {
        this.response = eDMResponse;
    }

    public EResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(EResponseStatus eResponseStatus) {
        this.status = eResponseStatus;
    }

    public void setErrorResponse(EDMErrorResponse eDMErrorResponse) {
        this.errorResponse = eDMErrorResponse;
    }

    public EDMErrorResponse getErrorResponse() {
        return this.errorResponse;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ResultBean resultBean = (ResultBean)object;
        return Objects.equals(this.request.getRequestID(), resultBean.getRequest().getRequestID());
    }

    public int hashCode() {
        int n = 5;
        n = 29 * n + Objects.hashCode(this.request.getRequestID());
        return n;
    }
}

