/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.PropertyId;
import eu.toop.playground.dc.ui.component.ConceptQueryComponent;
import eu.toop.playground.dc.ui.component.DocumentQueryComponent;
import eu.toop.playground.dc.ui.model.ConceptQueryFVBean;
import eu.toop.playground.dc.ui.model.DocumentQueryFVBean;
import eu.toop.playground.dc.ui.presenter.MainPresenter;
import java.io.IOException;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopLevelSlotComponent
extends Composite<VerticalLayout> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TopLevelSlotComponent.class.getName());
    private Div DSDQueryBox;
    private Div fetchBox;
    private Button fetchDSD;
    @PropertyId(value="procedure")
    TextField procedure = new TextField("Procedure: ");
    @PropertyId(value="dataProviderCountry")
    TextField dataProviderCountry = new TextField("Data Provider Country: ");
    @PropertyId(value="datasetIdentifier")
    ComboBox<String> datasetIdentifier = new ComboBox();

    public TopLevelSlotComponent(MainPresenter mainPresenter, ConceptQueryFVBean conceptQueryFVBean, ConceptQueryComponent conceptQueryComponent) {
        ((VerticalLayout)this.getContent()).setSpacing(false);
        ((VerticalLayout)this.getContent()).setPadding(false);
        this.DSDQueryBox = new Div();
        this.fetchBox = new Div();
        FormLayout formLayout = new FormLayout();
        this.procedure.getStyle().set("width", "48%");
        ((VerticalLayout)this.getContent()).setWidthFull();
        this.DSDQueryBox.setClassName("DSDQueryBox");
        this.datasetIdentifier.setItems((Object[])new String[]{"REGISTERED_ORGANIZATION_TYPE"});
        this.datasetIdentifier.setPlaceholder("Select: ");
        this.datasetIdentifier.setLabel("Dataset Type Identifier: ");
        Binder binder = new Binder(ConceptQueryFVBean.class, true);
        binder.setBean((Object)conceptQueryFVBean);
        binder.bindInstanceFields((Object)this);
        this.fetchDSD = new Button("fetch info");
        this.fetchDSD.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.fetchDSD.addClickListener((ComponentEventListener & Serializable)clickEvent -> {
            try {
                mainPresenter.populateConceptDatasetGrid(conceptQueryComponent, (String)this.datasetIdentifier.getValue(), this.dataProviderCountry.getValue());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        });
        this.fetchBox.add(new Component[]{this.fetchDSD});
        this.DSDQueryBox.add(new Component[]{formLayout});
        formLayout.add(new Component[]{this.dataProviderCountry, this.datasetIdentifier, this.fetchDSD});
        ((VerticalLayout)this.getContent()).add(new Component[]{this.procedure, this.DSDQueryBox});
    }

    public TopLevelSlotComponent(MainPresenter mainPresenter, DocumentQueryFVBean documentQueryFVBean, DocumentQueryComponent documentQueryComponent) {
        ((VerticalLayout)this.getContent()).setSpacing(false);
        ((VerticalLayout)this.getContent()).setPadding(false);
        this.DSDQueryBox = new Div();
        this.fetchBox = new Div();
        FormLayout formLayout = new FormLayout();
        this.procedure.getStyle().set("width", "48%");
        ((VerticalLayout)this.getContent()).setWidthFull();
        this.DSDQueryBox.setClassName("DSDQueryBox");
        this.datasetIdentifier.setItems((Object[])new String[]{"FINANCIAL_RECORD_TYPE"});
        this.datasetIdentifier.setPlaceholder("Select: ");
        this.datasetIdentifier.setLabel("Dataset Type Identifier: ");
        Binder binder = new Binder(DocumentQueryFVBean.class, true);
        binder.setBean((Object)documentQueryFVBean);
        binder.bindInstanceFields((Object)this);
        this.fetchDSD = new Button("fetch info");
        this.fetchDSD.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.fetchDSD.addClickListener((ComponentEventListener & Serializable)clickEvent -> {
            try {
                mainPresenter.populateDistributionGrid(documentQueryComponent, (String)this.datasetIdentifier.getValue(), this.dataProviderCountry.getValue());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        });
        this.fetchBox.add(new Component[]{this.fetchDSD});
        this.datasetIdentifier.addValueChangeListener((HasValue.ValueChangeListener & Serializable)componentValueChangeEvent -> mainPresenter.notifyDatasetIdentifierChange(componentValueChangeEvent));
        this.DSDQueryBox.add(new Component[]{formLayout});
        formLayout.add(new Component[]{this.dataProviderCountry, this.datasetIdentifier, this.fetchDSD});
        ((VerticalLayout)this.getContent()).add(new Component[]{this.procedure, this.DSDQueryBox});
    }
}

