/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.PropertyId;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import eu.toop.edm.model.EToopGenderCode;
import eu.toop.playground.dc.ui.component.AddressComponent;
import eu.toop.playground.dc.ui.model.AddressBean;
import eu.toop.playground.dc.ui.model.NaturalPersonFVBean;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public class NaturalPersonComponent
extends Composite<FormLayout> {
    @PropertyId(value="personID")
    TextField personID = new TextField("Person ID: ");
    @PropertyId(value="personGivenName")
    TextField personGivenName = new TextField("Person Given Name: ");
    @PropertyId(value="personFamilyName")
    TextField personFamilyName = new TextField("Person Family Name: ");
    @PropertyId(value="personGenderCode")
    ComboBox<String> personGenderCode = new ComboBox();
    @PropertyId(value="personBirthName")
    TextField personBirthName = new TextField("Person Birth Name: ");
    @PropertyId(value="personBirthDate")
    DatePicker personBirthDate = new DatePicker("Person Birth Date: ");
    @PropertyId(value="personPlaceOfBirthAddressPostName")
    TextField personPlaceOfBirthAddressPostName = new TextField("Person Place of Birth: ");
    AddressComponent address;
    H5 personalInformationHeader = new H5("Natural Person Information: ");
    Div addressContainer;

    public NaturalPersonComponent(NaturalPersonFVBean naturalPersonFVBean) {
        Binder binder = new Binder(NaturalPersonFVBean.class, true);
        binder.setBean((Object)naturalPersonFVBean);
        binder.bindInstanceFields((Object)this);
        if (naturalPersonFVBean.getAddress() == null) {
            naturalPersonFVBean.setAddress(new AddressBean());
        }
        this.address = new AddressComponent(naturalPersonFVBean.getAddress());
        H5 h5 = new H5("Natural Person Address:");
        this.addressContainer = new Div(new Component[]{h5, this.address});
        this.addressContainer.setClassName("address");
        this.personGenderCode.setItems((Collection)Arrays.stream(EToopGenderCode.values()).map(EToopGenderCode::getID).collect(Collectors.toList()));
        this.personGenderCode.setLabel("Person Gender Code: ");
        ((FormLayout)this.getContent()).add(new Component[]{this.personalInformationHeader});
        ((FormLayout)this.getContent()).getElement().appendChild(new Element[]{ElementFactory.createBr()});
        ((FormLayout)this.getContent()).add(new Component[]{this.personID, this.personGivenName, this.personFamilyName, this.personGenderCode, this.personBirthName, this.personBirthDate, this.personPlaceOfBirthAddressPostName});
        ((FormLayout)this.getContent()).getElement().appendChild(new Element[]{ElementFactory.createBr()});
        ((FormLayout)this.getContent()).add(new Component[]{this.addressContainer});
    }
}

