/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import eu.toop.edm.EDMRequest;
import eu.toop.edm.model.DatasetPojo;
import eu.toop.edm.response.IEDMResponsePayloadDocument;
import eu.toop.edm.response.IEDMResponsePayloadDocumentReference;
import eu.toop.playground.dc.ui.component.RequestByIDButtonComponent;
import eu.toop.playground.dc.ui.model.DocumentResponseFVBean;
import eu.toop.playground.dc.ui.presenter.MainPresenter;
import java.io.ByteArrayInputStream;
import java.io.Serializable;

public class DocumentResponseComponent
extends Composite<VerticalLayout> {
    H2 documentHead = new H2("Document Metadata: ");
    Div documentBox;
    private DocumentResponseFVBean documentResponseFVBean;

    public DocumentResponseComponent(DocumentResponseFVBean documentResponseFVBean, MainPresenter mainPresenter) {
        this.documentResponseFVBean = documentResponseFVBean;
        this.documentBox = new Div();
        this.documentBox.setClassName("documentBox");
        TreeGrid treeGrid = new TreeGrid(DatasetPojo.class);
        treeGrid.setItems(documentResponseFVBean.getDatasetList());
        treeGrid.removeAllColumns();
        if (documentResponseFVBean.getResponse().getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocumentReference) {
            ((Grid.Column)treeGrid.addColumn((ValueProvider & Serializable)datasetPojo -> datasetPojo.getAllIDs().get(0)).setResizable(true)).setHeader("Document Number");
        } else if (documentResponseFVBean.getResponse().getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocument) {
            treeGrid.addColumn((ValueProvider & Serializable)datasetPojo -> datasetPojo.getAllIDs().get(0)).setHeader("Document Number").setResizable(true);
        }
        treeGrid.addColumn(DatasetPojo::getAllDescriptions).setHeader("Description").setResizable(true);
        treeGrid.addColumn(DatasetPojo::getAllTitles).setHeader("Title").setResizable(true);
        treeGrid.addColumn((ValueProvider & Serializable)datasetPojo -> datasetPojo.getDistribution().getDocumentType()).setHeader("Document Type").setResizable(true);
        treeGrid.addColumn(DatasetPojo::getLanguage).setHeader("Language").setResizable(true);
        treeGrid.addColumn(DatasetPojo::getIssuedDT).setHeader("Release Date").setResizable(true);
        treeGrid.addColumn((ValueProvider & Serializable)datasetPojo -> datasetPojo.getCreator().getName()).setHeader("Creator Name").setResizable(true);
        treeGrid.addColumn((ValueProvider & Serializable)datasetPojo -> datasetPojo.getCreator().getID()).setHeader("Creator ID").setResizable(true);
        if (documentResponseFVBean.getResponse().getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocumentReference) {
            treeGrid.addComponentColumn((ValueProvider & Serializable)datasetPojo -> {
                RequestByIDButtonComponent requestByIDButtonComponent = new RequestByIDButtonComponent(mainPresenter, (String)datasetPojo.getAllIDs().get(0), this);
                return requestByIDButtonComponent;
            }).setHeader("Fetch Document").setResizable(true);
        }
        if (documentResponseFVBean.getResponse().getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocument) {
            treeGrid.addComponentColumn((ValueProvider & Serializable)datasetPojo -> {
                String string = "This is an example certificate document";
                Icon icon = new Icon(VaadinIcon.DOWNLOAD);
                icon.setColor("097bd3");
                icon.setSize("30");
                Anchor anchor = new Anchor((AbstractStreamResource)new StreamResource("demo.pdf", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(string.getBytes())), "");
                anchor.getElement().setAttribute("download", true);
                anchor.setHref((AbstractStreamResource)new StreamResource("demo.pdf", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(string.getBytes())));
                anchor.add(new Component[]{icon});
                return anchor;
            }).setHeader("Download").setResizable(true);
        }
        this.documentBox.add(new Component[]{treeGrid});
        ((VerticalLayout)this.getContent()).setPadding(false);
        ((VerticalLayout)this.getContent()).add(new Component[]{this.documentHead, this.documentBox});
    }

    public DocumentResponseFVBean getDocumentResponseFVBean() {
        return this.documentResponseFVBean;
    }

    public void downloadXML(EDMRequest eDMRequest) {
    }
}

