/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import eu.toop.edm.EDMRequest;
import eu.toop.playground.dc.ui.component.DocumentResponseComponent;
import eu.toop.playground.dc.ui.component.TopLevelSlotComponent;
import eu.toop.playground.dc.ui.model.DocumentQueryFVBean;
import eu.toop.playground.dc.ui.model.dto.DSDDatasetResponseDto;
import eu.toop.playground.dc.ui.model.enums.EQueryDefinition;
import eu.toop.playground.dc.ui.presenter.MainPresenter;
import eu.toop.playground.dc.ui.util.Utilities;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.olli.FileDownloadWrapper;

public class DocumentQueryComponent
extends Composite<VerticalLayout> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DocumentResponseComponent.class.getName());
    private MainPresenter presenter;
    TopLevelSlotComponent topLevelSlotComponent;
    Div distributionSelectionBox = new Div();
    Div messageCreationBox = new Div();
    H3 distributionSelectionHeader = new H3("Data Provider and Distribution Selection: ");
    H3 createDocumentQueryHeader = new H3("Create DocumentQuery:  ");
    Grid<DSDDatasetResponseDto> datasetGrid;
    String selectedQueryDef;
    Button createRequestBtn;
    Button downloadBtn = new Button();

    public DocumentQueryComponent(MainPresenter mainPresenter, String string, DocumentQueryFVBean documentQueryFVBean) {
        this.presenter = mainPresenter;
        this.selectedQueryDef = string;
        this.distributionSelectionBox.setClassName("distributionSelectionBox");
        this.topLevelSlotComponent = new TopLevelSlotComponent(mainPresenter, documentQueryFVBean, this);
        this.createRequestBtn = new Button("Create Request");
        this.createRequestBtn.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.messageCreationBox.add(new Component[]{this.createDocumentQueryHeader, this.createRequestBtn});
        this.downloadBtn.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.downloadBtn.setIcon((Component)new Icon(VaadinIcon.DOWNLOAD_ALT));
        ((VerticalLayout)this.getContent()).add(new Component[]{this.topLevelSlotComponent});
    }

    public void renderDatasetList(List<DSDDatasetResponseDto> list) {
        if (Utilities.datasetGridExists(this.datasetGrid)) {
            this.distributionSelectionBox.remove(new Component[]{this.datasetGrid});
            this.distributionSelectionBox.remove(new Component[]{this.messageCreationBox});
        }
        this.datasetGrid = new Grid(DSDDatasetResponseDto.class);
        this.datasetGrid.setItems(list);
        this.datasetGrid.removeAllColumns();
        this.datasetGrid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.datasetGrid.addColumn(DSDDatasetResponseDto::getDatasetId).setHeader("DatasetIdentifier").setResizable(true);
        this.datasetGrid.addColumn((ValueProvider & Serializable)dSDDatasetResponseDto -> ((DSDDatasetResponseDto)list.get(0)).getParticipantId().getValue().toString()).setHeader("ParticipantID").setResizable(true);
        this.datasetGrid.addColumn((ValueProvider & Serializable)dSDDatasetResponseDto -> ((DSDDatasetResponseDto)list.get(0)).getParticipantId().getScheme()).setHeader("Participant Scheme ID").setResizable(true);
        this.datasetGrid.addColumn((ValueProvider & Serializable)dSDDatasetResponseDto -> ((DSDDatasetResponseDto)list.get(0)).getDoctypeId().getValue()).setHeader("Document Type ID").setResizable(true);
        this.datasetGrid.addColumn((ValueProvider & Serializable)dSDDatasetResponseDto -> ((DSDDatasetResponseDto)list.get(0)).getDoctypeId().getScheme()).setHeader("Document Scheme ID").setResizable(true);
        this.datasetGrid.addColumn(DSDDatasetResponseDto::getDistributionFormat).setHeader("Format").setResizable(true);
        this.datasetGrid.addColumn(DSDDatasetResponseDto::getAccessServiceConforms).setHeader("Conforms to").setResizable(true);
        MultiSelect multiSelect = this.datasetGrid.asMultiSelect();
        multiSelect.addSelectionListener((MultiSelectionListener & Serializable)multiSelectionEvent -> {
            if (multiSelect.getSelectedItems().size() == 1) {
                this.distributionSelectionBox.add(new Component[]{this.messageCreationBox});
            } else if (multiSelect.getSelectedItems().size() == 0) {
                this.distributionSelectionBox.remove(new Component[]{this.messageCreationBox});
            }
        });
        this.createRequestBtn.addClickListener((ComponentEventListener & Serializable)clickEvent -> {
            for (DSDDatasetResponseDto dSDDatasetResponseDto : multiSelect.getSelectedItems()) {
                if (this.selectedQueryDef.equals(EQueryDefinition.DOCUMENT.getQueryDefinition())) {
                    this.presenter.createDocumentRequestMessage(this, dSDDatasetResponseDto);
                    continue;
                }
                if (!this.selectedQueryDef.equals(EQueryDefinition.DOCUMENT_REF.getQueryDefinition())) continue;
                this.presenter.createDocumentRefRequestMessage(this, dSDDatasetResponseDto);
            }
        });
        this.distributionSelectionBox.add(new Component[]{this.distributionSelectionHeader, this.datasetGrid});
        ((VerticalLayout)this.getContent()).add(new Component[]{this.distributionSelectionHeader, this.distributionSelectionBox});
    }

    public void downloadXML(EDMRequest eDMRequest) {
        FileDownloadWrapper fileDownloadWrapper = new FileDownloadWrapper(new StreamResource("TOOPRequest.xml", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(Objects.requireNonNull(eDMRequest.getWriter().getAsBytes()))));
        fileDownloadWrapper.wrapComponent((Component)this.downloadBtn);
        Notification notification = new Notification("Created TOOPRequest Document", 3000, Notification.Position.TOP_START);
        notification.addThemeVariants(new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
        notification.open();
        this.messageCreationBox.add(new Component[]{fileDownloadWrapper});
    }
}

