/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.accordion.Accordion;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.radiobutton.RadioGroupVariant;
import eu.toop.playground.dc.ui.component.LegalPersonComponent;
import eu.toop.playground.dc.ui.component.NaturalPersonComponent;
import eu.toop.playground.dc.ui.model.LegalPersonFVBean;
import eu.toop.playground.dc.ui.model.NaturalPersonFVBean;
import eu.toop.playground.dc.ui.presenter.MainPresenter;
import java.io.Serializable;

public class DataSubjectComponent
extends Composite<FormLayout> {
    private MainPresenter presenter;
    Accordion dataSubjectAccordion = null;
    Accordion authorizedRepresentativeAccordion = null;
    Button authorizedRepresentativeBtn;

    public DataSubjectComponent(MainPresenter mainPresenter) {
        this.presenter = mainPresenter;
        RadioButtonGroup radioButtonGroup = new RadioButtonGroup();
        radioButtonGroup.setLabel("Create Request for Natural or Legal Person: ");
        radioButtonGroup.setItems((Object[])new String[]{"Natural Person", "Legal Person"});
        radioButtonGroup.addThemeVariants(new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
        radioButtonGroup.addValueChangeListener((HasValue.ValueChangeListener & Serializable)componentValueChangeEvent -> {
            if (this.accordionExists(this.dataSubjectAccordion)) {
                ((FormLayout)this.getContent()).remove(new Component[]{this.dataSubjectAccordion});
            }
            mainPresenter.initDataSubject(componentValueChangeEvent);
        });
        ((FormLayout)this.getContent()).add(new Component[]{radioButtonGroup});
        this.authorizedRepresentativeBtn = new Button("Authorized Representative", (Component)new Icon(VaadinIcon.PLUS_CIRCLE));
        this.authorizedRepresentativeBtn.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_SMALL, ButtonVariant.LUMO_PRIMARY});
        this.authorizedRepresentativeBtn.addClickListener((ComponentEventListener & Serializable)clickEvent -> mainPresenter.initAuthorizedRepresentative());
        ((FormLayout)this.getContent()).add(new Component[]{this.authorizedRepresentativeBtn});
    }

    public void renderNP(NaturalPersonFVBean naturalPersonFVBean) {
        this.presenter.resetLP();
        System.out.println("renderNP called");
        this.resetDataSubjectAccordion();
        NaturalPersonComponent naturalPersonComponent = new NaturalPersonComponent(naturalPersonFVBean);
        this.dataSubjectAccordion.add("Natural Person", (Component)naturalPersonComponent);
        ((FormLayout)this.getContent()).add(new Component[]{this.dataSubjectAccordion});
    }

    public void renderLP(LegalPersonFVBean legalPersonFVBean) {
        this.presenter.resetNP();
        System.out.println("renderLP called");
        this.resetDataSubjectAccordion();
        LegalPersonComponent legalPersonComponent = new LegalPersonComponent(legalPersonFVBean);
        this.dataSubjectAccordion.add("Legal Person", (Component)legalPersonComponent);
        ((FormLayout)this.getContent()).add(new Component[]{this.dataSubjectAccordion});
    }

    public void renderAR(NaturalPersonFVBean naturalPersonFVBean) {
        NaturalPersonComponent naturalPersonComponent = new NaturalPersonComponent(naturalPersonFVBean);
        if (!this.accordionExists(this.authorizedRepresentativeAccordion)) {
            System.out.println("ACCORDION ADD CALLED: ");
            this.authorizedRepresentativeAccordion = new Accordion();
            this.authorizedRepresentativeBtn.setText("Remove Authorized Representative: ");
            this.authorizedRepresentativeBtn.setIcon((Component)new Icon(VaadinIcon.MINUS_CIRCLE));
            this.authorizedRepresentativeBtn.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_SMALL, ButtonVariant.LUMO_ERROR});
            this.authorizedRepresentativeAccordion.add("Authorized Representative", (Component)naturalPersonComponent);
            ((FormLayout)this.getContent()).add(new Component[]{this.authorizedRepresentativeAccordion});
            this.authorizedRepresentativeBtn.getStyle().set("backgroundColor", "#f52419");
        } else if (this.accordionExists(this.authorizedRepresentativeAccordion)) {
            System.out.println("AUTHORIZED ACCORDION REMOVE called");
            this.authorizedRepresentativeBtn.setIcon((Component)new Icon(VaadinIcon.PLUS_CIRCLE));
            this.authorizedRepresentativeBtn.setText("Authorized Representative");
            ((FormLayout)this.getContent()).remove(new Component[]{this.authorizedRepresentativeAccordion});
            this.resetAuthRepAccordion();
            this.presenter.resetAuthorizedRepresentative();
            this.authorizedRepresentativeBtn.getStyle().set("backgroundColor", "#1676f3");
        }
    }

    public void resetAuthRepAccordion() {
        this.authorizedRepresentativeAccordion = null;
    }

    public void resetDataSubjectAccordion() {
        this.dataSubjectAccordion = new Accordion();
    }

    public boolean accordionExists(Accordion accordion) {
        return accordion != null;
    }
}

